#ifndef _HALDANE
#define _HALDANE
#include "basic.h"

inline Float addrec(Float tht1, Float tht2) {
  return tht1 + tht2 - 2.0*tht1*tht2;
}

// Haldane's map functions

inline Float centimorgan(Float theta) {
  // change recombination fraction to map distance in centimorgans
  return -0.5*log(1.0 - 2.0*theta)*100.0;
}

inline Float recombfraccent(Float dist) {
  // change centimorgans to recombination fraction
  if (dist < 0) dist = -dist;
  return 0.5*(1.0 - exp(-2.0*dist/100.0));
}

#endif // _HALDANE
