#ifndef _HAPLODIST
#define _HAPLODIST
#include "basic.h"
#include "viterbidist.h"

class Haplodist : public Viterbidist {
public:
  static Haplodist *gethaplodist(const string &haplo, const string &inher,
                                 const string &ihaplo, const string &founder);
  virtual string describe() const {return "haplotype";}
  virtual void print() const;
  static void setgraph(Graph *g) {graph = g;}

  /// Returns true if the family will be used by the distribution.
  virtual bool usefamily(Family */*fam*/) const {return true;}
  /// Returns true if families that have no uninformative markers are to be
  /// used
  virtual bool useuninformative() const {return true;}

protected:
  Haplodist(const string &hapf, const string &inhf, const string &ihapf,
            const string &fndrf, const string &p = "hpt");

  static Graph *graph;
  Outfile haplotypefile;
  Outfile inherfile;
  Outfile ihaplotypefile;
  Outfile founderallelefile;

  void ivout(IVVec ivpath, bool pick_mle);
  virtual void printresults(const vector<IntMat> &curbits,
                            vector<IntMat> &alleles,
                            const vector<IntMat> founderalleles);
  void printheaders();
private:
  Uint colwidth;

  void setbits(Person *p, IntVec firstfounderbit, Uint &j, IntMat curbits,
               IV v1) const;
  void updatefirstfounderbit(Person *p, int &fb, int &tb, IV v0, IV v1,
                             Float tht, bool pick_mle) const;
  void updatefirstgcbit(Foundercouple *fc, int &fb, int &tb, IV v0, IV v1,
                        Float tht, bool pick_mle) const;

  void outputfile(ostream &f, const vector<IntMat> &x, Person *firstfam,
                  bool transunknown = false);
  void markerheader(ostream &f, Uint maxlen);
  void printper(ostream &f, Person *p);
  void printline(ostream &f, Person *p, const vector<IntMat> &x, int sex,
                 bool transunknown);

  virtual void set(FloatVec pv, Uint pos);
  virtual void reset(Uint np);
};

#endif // _HAPLODIST
