#include "files.h"
#include "ibddist.h"

//////////////////////////////////////////////////////////////////////
// IBDdist

void IBDdist::nextfam(Uint /*pos*/, DoubleVec /*p0*/) {
  familydata.push_back(new Familydata(this));
  Familydata *famdat = familydata.back();
  // Set things up for calculations
  
  famdat->initialize();
  // Calculate prior
  famdat->collectpairs();
  famdat->findprior();
}

void IBDdist::set(FloatVec pv, Uint pos) {
  // Calculate posterior
  familydata.back()->findposterior(pv, pos);
}

void IBDdist::skipfam() {
  if (!familydata.empty()) {
    delete familydata.back();
    familydata.pop_back();
  }
}

void IBDdist::reset(Uint np) {
  while (!familydata.empty()) {
    delete familydata.back();
    familydata.pop_back();
  }
  npos = np;
}

IBDdist *IBDdist::getibddist(const string &pt, const string &type) {
  Distribution *dist = Distribution::finddistribution("IBD" + type, pt);
  if (dist != 0) return (IBDdist *)dist;
  else return new IBDdist(pt, type);
}

Uint IBDdist::countpairs(Uint ifa) const {
  return familydata[ifa]->findIBD->countpairs();
}

Uint IBDdist::countpairs() const {
  return countpairs(families.size() - 1);
}

IBDdist::Familydata::~Familydata() {
  DELETEVEC(person1);
  DELETEVEC(person2);
  DELETEVEC(prioribd1);
  DELETEVEC(prioribd2);
  DELETEMAT(posterioribd1);
  DELETEMAT(posterioribd2);
  delete findIBD;
}
