#ifndef _IBDDIST
#define _IBDDIST
#include "distribution.h"
#include "findibd.h"

class IBDdist : public Distribution {
public:
  virtual string describe() const {return "IBD" + pairtype;}
  static IBDdist *getibddist(const string &pt, const string &type);

  Uint countpairs() const;
  Uint countpairs(Uint ifa) const;
  void getpairs(Uint ifa, StringVec &p1, StringVec &p2)
    {p1 = familydata[ifa]->person1; p2 = familydata[ifa]->person2;}
  void getprioribd(Uint ifa, DoubleVec &i1, DoubleVec &i2)
    {i1 = familydata[ifa]->prioribd1; i2 = familydata[ifa]->prioribd2;}
  void getposterioribd(Uint ifa, DoubleVec &i1, DoubleVec &i2, Uint pos)
    {i1 = familydata[ifa]->posterioribd1[pos];
    i2 = familydata[ifa]->posterioribd2[pos];}

  virtual bool usefamily(Family *) const {return true;}
protected:

  class Familydata {
  protected:
    IBDdist *owner;
  public:
    void initialize() {
      findIBD = new FindIBD(owner->curfamily(), owner->pairtype);
      Uint npairs = owner->countpairs();
      if (npairs > 0) {
        NEWVEC(string, person1, npairs);
        NEWVEC(string, person2, npairs);
        NEWVEC(Double, prioribd1, npairs);
        NEWVEC(Double, prioribd2, npairs);
        NEWMAT(Double, posterioribd1, owner->npos, npairs);
        NEWMAT(Double, posterioribd2, owner->npos, npairs);
      }
      else {
        person1 = person2 = 0;
        prioribd1 = prioribd2 = 0;
        posterioribd1 = posterioribd2 = 0;
      }
    }
    void collectpairs() {findIBD->collectpairs(person1, person2);}
    void findprior() {findIBD->findprior(prioribd1, prioribd2);}
    void findposterior(DoubleVec prob, Uint pos)
      {findIBD->findposterior(prob, posterioribd1[pos], posterioribd2[pos]);}
    Familydata(IBDdist *own) : owner(own), findIBD(0) {}
    Familydata(const Familydata &fd) : owner(fd.owner), findIBD(0) {}
    
    ~Familydata();
    FindIBD *findIBD;
    StringVec person1;
    StringVec person2;
    DoubleVec prioribd1;
    DoubleVec prioribd2;
    DoubleMat posterioribd1;
    DoubleMat posterioribd2;
  };
  friend class IBDdist::Familydata;
  typedef vector<Familydata *> Familydatavector;
  Familydatavector familydata;

  IBDdist(const string &p, const string &type) :
      Distribution(p), pairtype(type) {}

  string pairtype;
  Outfile priorpairwiseibd;
  Outfile posteriorpairwiseibd;

  virtual void reset(Uint np);
  virtual void nextfam(Uint pos = 0, DoubleVec p0 = 0);
  virtual void set(FloatVec pv, Uint pos);
  virtual void skipfam();

  virtual void writeprob(const Map &/*map*/) {}
  virtual void readprob(Infile& /*f*/) {}
  virtual void writenull() {}
  virtual void readnull(Infile& /*f*/) {}
};

#endif // _IBDDIST
