#include <iomanip>
#include "files.h"
#include "ibdpairmodel.h"
#include "options.h"
#include "utils.h"
#include "fmtout.h"

void IBDpairmodel::output() {
  assertinternal(outfile.assigned() && foutfile.assigned());
  if (!outfile.is_open()) outfile.open();
  if (!foutfile.is_open()) foutfile.open();
  out(outfile, true);
  out(foutfile, false);
  outfile.close();
  foutfile.close();
}

void IBDpairmodel::out(ostream &f, bool prior) {
  header(f, prior);
  for (Uint fam = 0; fam < nfam(); fam++)
    lines(f, fam, prior);
}

void IBDpairmodel::lines(ostream &f, Uint ifa, bool prior) {
  IBDdist *dist = (IBDdist *)distribution;
  DoubleVec ibd1;
  DoubleVec ibd2;
  DoubleVec prioribd1;
  DoubleVec prioribd2;
  StringVec person1;
  StringVec person2;
  dist->getpairs(ifa, person1, person2);
  dist->getprioribd(ifa, prioribd1, prioribd2);
  for (Uint pair = 0; pair < dist->countpairs(ifa); pair++) {
    if (prioribd1[pair] + prioribd2[pair] == 0.0) continue;
    Uint w1 = max_(person1[pair].length(), 7) + 1;
    Uint w2 = max_(person2[pair].length(), 7) + 1;
    for (Uint pos = 0; pos < (prior ? 1 : npos()); pos++) {
      if (prior) dist->getprioribd(ifa, ibd1, ibd2);
      else dist->getposterioribd(ifa, ibd1, ibd2, pos);
      if (prior || pt == "spt" || map->inbetween[pos] ||
          map->shouldfindp[map->leftmarker[pos]]) {
        printfamid(f, getfamid(ifa));
        if (!prior) {
          f.setf(ios::right, ios::adjustfield);
          fmtout(f, 7, 3, position(pos));
        }
        f << "  ";
        fmtout(f, w1, person1[pair]);
        fmtout(f, w2, person2[pair]);
        Double ibd0 = fabs(1.0 - ibd1[pair] - ibd2[pair]);
        if (ibd0 < 1e-13) ibd0 = 0.0;
        fmtout(f, 12, 8, ibd0, 1, 0.001);
        fmtout(f, 12, 8, fabs(ibd1[pair]), 1, 0.001);
        fmtout(f, 12, 8, fabs(ibd2[pair]), 1, 0.001);
        if (!prior) f << "  " << markername(pos);
        f << "\n";
      }
    }
  }
}

void IBDpairmodel::print() const {
  message("PAIRWISEIBD " + pt + " " + outfile.name + " " + foutfile.name);
}

void IBDpairmodel::header(ostream &f, bool prior) {
  f.setf(ios::left, ios::adjustfield);
  f << setw(options->maxfamidlen + 2) << "Family";
  if (!prior) f << "location";
  f << "     pair            p(IBD=0)    p(IBD=1)    p(IBD=2)";
  if (!prior) f << " marker";
  f << "\n";
}
