#ifndef _IBDPAIRMODEL
#define _IBDPAIRMODEL
#include "basic.h"
#include "model.h"
#include "ibddist.h"

class IBDpairmodel : public Model {
public:
  IBDpairmodel(const string &p, const string &type,
               const string &prif, const string &postf) : Model(p) {
    distribution = IBDdist::getibddist(p, type);
    outfile.setname(prif, "prior." + pt);
    foutfile.setname(postf, "posterior." + pt);
    outfile.optcheck("pairwise prior IBD probability file");
    foutfile.optcheck("pairwise posterior probability IBD file");
  }
protected:
  virtual void output();
  virtual void out(ostream &f, bool prior);
  virtual void totline(ostream &/*f*/, Uint /*pos*/) {}
  virtual void famline(ostream &/*f*/, Uint /*ifa*/, Uint /*pos*/) {}
  virtual void header(ostream &f, bool prior);
  virtual void lines(ostream &f, Uint fam, bool prior);
  virtual void totheader(ostream &/*f*/) {}
  virtual void famheader(ostream &/*f*/) {}
  virtual void print() const;
  
};

#endif // _IBDPAIRMODEL
