#include <sys/stat.h>
#include <stdio.h>
#include <errno.h>
#include "files.h"
#include "inherdist.h"
#include "options.h"
#include "family.h"

//////////////////////////////////////////////////////////////////////
// Inherdist

Inherdist::~Inherdist() {
  if (!storeresults) {
    // Remove options->inherdistfolder and everything in it
    for (Uint fam = 0; fam < families.size(); fam++) {
      const string famid = families[fam]->id;
      for (Uint pos = 0; pos < npos; pos++) {
        const string fn = getfilename(famid, pos);
        remove(fn.c_str());
      }
    }
    remove(options->inherdistfolder.c_str());
  }
}

Inherdist *Inherdist::getinherdist(const string &pt) {
  Distribution *dist = Distribution::finddistribution("inherdist", pt);
  if (dist != 0) return (Inherdist *)dist;
  else return new Inherdist(pt);
}

void Inherdist::getdist(const string &famid, Uint numiv, Uint gam, DoubleVec p) {
  const string fn = getfilename(famid, gam);
  ifstream f(fn.c_str(), ios::in | ios::binary);
  assertcond(f != 0, "Unable to read inheritance vector file " + fn);
  f.seekg(0, ios::beg);
  f.read((char *)(p VEC_GET_DATA), numiv*sizeof(Float));
  assertcond(!f.fail(), "Error reading inheritance vector file " + fn);
}
  
void Inherdist::reset(Uint np) {
  npos = np;
}

bool isfolder(const string &fn) {
  struct stat statbuf;
  return stat(fn.c_str(), &statbuf) == 0 && (statbuf.st_mode & S_IFDIR);
}

void Inherdist::set(FloatVec pv, Uint pos) {
  if (!isfolder(options->inherdistfolder))
    if (mkdir(options->inherdistfolder.c_str(), 493) != 0)
      assertcond(errno == EEXIST, "Unable to create directory " +
                 options->inherdistfolder);
    
  const string fn = getfilename(families.back()->id, pos);
  ofstream f(fn.c_str(), ios::out | ios::binary);
  assertcond(f != 0, "Unable to write inheritance vector file " + fn);
  f.seekp(ios::beg);
  f.write((char *)(pv VEC_GET_DATA), families.back()->numiv*sizeof(Float));
  assertcond(!f.fail(), "Error write inheritance vector file " + fn);  
}

string Inherdist::getfilename(const string &famid, Uint pos) const {
  return options->inherdistfolder + "/" + famid + "." + pt + "." + pos;
}
