#ifndef _INHERDIST
#define _INHERDIST
#include "distribution.h"

class Inherdist : public Distribution {
public:
  // This class writes distribution of inheritance vectors to files called
  //    options->inherdistfolder/familyid.pt.gam 
  // where the default of options->inherdistfolder is inherdist, familyid is
  // the id of the family, pt is mpt or spt, and gam is the number of locus
  
  virtual ~Inherdist();
  virtual string describe() const {return "inherdist";}

  static Inherdist *getinherdist(const string &pt);

  void getdist(const string &famid, Uint numiv, Uint gam, DoubleVec p);
  Family *getfirstfamily() {return *families.begin();}

  virtual bool usefamily(Family *) const {return true;}
protected:
  bool storeresults;
                 
  Inherdist(const string &p, bool store = false) :
      Distribution(p), storeresults(store) {}
  
  virtual void reset(Uint np);
  virtual void nextfam(Uint /*pos*/ = 0, DoubleVec /*p0*/ = 0) {}
  virtual void set(FloatVec pv, Uint pos);
  virtual string getfilename(const string &famid, Uint pos) const;
  virtual void skipfam() {}

  virtual void writeprob(const Map &/*map*/) {}
  virtual void readprob(Infile& /*f*/) {}
  virtual void writenull() {}
  virtual void readnull(Infile& /*f*/) {}
};

#endif // _INHERDIST
