#include "kinship.h"
#include "family.h"
#include "vecutil.h"
#include "warning.h"

Kinship::Kinship(Family *fam) : curdim(fam->num) {
  // Set up the kinship matrix
  kinship = newsymmetricmatrix<Double>(curdim);
  zero(kinship[0], (curdim*(curdim + 1))/2);

  // Calculate kinship
  Uint idx = 0;
  for (Person *p = fam->first; p != 0; p = p->next, idx++) {
    p->nmrk = idx;
    if (p->founder()) kinship[idx][idx] = 1.0;
    else {
      for (Uint j = 0; j < idx; j++)
        kinship[idx][j] = .5*(getkinship(j, p->father->nmrk) +
                              getkinship(j, p->mother->nmrk));
      kinship[idx][idx] = 1.0 + getkinship(p->father->nmrk, p->mother->nmrk);
    }
  }
}

Kinship::~Kinship() {
  DELETEVEC(kinship);
}

Float Kinship::getkinship(Uint i, Uint j) {
  if (i < j) {
    Uint tmp = i;
    i = j;
    j = tmp;
  }
  assertinternal(j < curdim);
  return kinship[i][j];
}
