#include "files.h"
#include "linkagedist.h"
#include "options.h"
#include "family.h"
#include "vecutil.h"

///////////////////////////////////////////////////////////////////////
// Linkagedist

Linkagedist::~Linkagedist() {
  while (!familydata.empty()) {
    delete familydata.back();
    familydata.pop_back();
  }
  DELETEVEC(Lnull);
}

void Linkagedist::reset(Uint np) {
  while (!familydata.empty()) {
    delete familydata.back();
    familydata.pop_back();
  }
  npos = np;
  DELETEVEC(Lnull);
  NEWVEC(Double, Lnull, np);
}

void Linkagedist::nextfam(Uint pos, DoubleVec p0) {
  if (pos == 0) 
    if (options->sexlinked == getsexlinked())
      familydata.push_back(new Familydata(this));
  IV numiv = curfamily()->numiv;
  if (isnullconstant()) {
    Lnull[0] = sum<Double>(calclinkage->vec, numiv)/Double(numiv);
    copyval(Lnull, Lnull[0], npos);
  }
  else
    for (IV v = 0; v < numiv; v++) Lnull[pos] += calclinkage->vec[v]*p0[v];
}

void Linkagedist::set(FloatVec pv, Uint pos) {
  if (options->sexlinked == getsexlinked()) {
    Double LR = 0.0;
    DoubleVec L = calclinkage->vec;
    IV numiv = curfamily()->numiv;
    for (IV v = 0; v < numiv; v++) LR += pv[v]*L[v];
    LR /= Lnull[pos];
    familydata.back()->LR[pos] = LR;
  }
}

void Linkagedist::skipfam() {
  if (options->sexlinked == getsexlinked()) {
    if (!familydata.empty()) {
      delete familydata.back();
      familydata.pop_back();
    }
  }
}
