#ifndef _LINKAGEDIST
#define _LINKAGEDIST
#include "distribution.h"
#include "calclinkage.h"

class Linkagedist : public Distribution {
public:
  virtual ~Linkagedist();

  // Function for extracting result
  void getresult(DoubleMat LR)
    {for (Uint i = 0; i < familydata.size(); i++) LR[i] = familydata[i]->LR;}
  bool getsexlinked() const {return calclinkage->getsexlinked();}

  virtual string describe() const {return calclinkage->describe();}

  /// Returns true if families that have no uninformative markers are to be
  /// used
  virtual bool useuninformative() const {return false;}
protected:
  Calclinkage *calclinkage;
  DoubleVec Lnull;

  Linkagedist(const string &p, Calclinkage *clc) :
      Distribution(p), calclinkage(clc), Lnull(0) {}
  class Familydata {
  protected:
    Linkagedist *owner;
  public:
    Familydata(Linkagedist *own) : owner(own) {
      NEWVEC(Double, LR, owner->npos);
    }
    Familydata(const Familydata &fd) : owner(fd.owner) {
      NEWVEC(Double, LR, owner->npos);
    }
      
    ~Familydata() {DELETEVEC(LR);}
    DoubleVec LR;
  };
  friend class Linkagedist::Familydata;
  typedef vector<Familydata *> Familydatavector;
  Familydatavector familydata;

  virtual void reset(Uint np);
  virtual void nextfam(Uint pos = 0, DoubleVec p0 = 0);
  virtual void set(FloatVec pv, Uint pos);
  virtual void skipfam();
  virtual void writeprob(const Map &/*map*/) {}
  virtual void readprob(Infile& /*f*/) {}
  virtual void writenull() {}
  virtual void readnull(Infile& /*f*/) {}
};

#endif // _LINKAGEDIST
