#include <iostream>
#include "files.h"
#include "model.h"
#include "linkagemodel.h"
#include "linkagedist.h"
#include "maximize.h"
#include "options.h"
#include "fmtout.h"

DoubleMat LRp = 0;
Uint gfam;

Double f_lod(Double x, Uint pos) {
  Double l = 0.0;
  for (Uint fam = 0; fam < gfam; fam++)
    l += log10(1.0 - x + x*LRp[fam][pos]);
  return l;
}

///////////////////////////////////////////////////////////////////
// Linkagemodel

bool Linkagemodel::getsexlinked() const {
  return ((Linkagedist *)distribution)->getsexlinked();
}

DoubleVec Linkagemodel::LOD(bool dohet) {
  DoubleVec rlod;
  NEWVEC(Double, rlod, npos());
  DELETEVEC(LRp);
  NEWVEC(DoubleVec, LRp, nfam());
  ((Linkagedist *)distribution)->getresult(LRp);
  gfam = nfam();
  if (!dohet)
    for (Uint pos = 0; pos < npos(); pos++) rlod[pos] = f_lod(1.0, pos);
  else {
    Maximizor mz(0, 1, 50, 11, false);
    for (Uint pos = 0; pos < npos(); pos++)
      mz.maximize(f_lod(0.0, pos), 0.0, f_lod, pos, alphahat[pos], rlod[pos]);
  }
  return rlod;
}

void Linkagemodel::output() {
  if (getsexlinked() == options->sexlinked) {
    lod = LOD(false);
    if (heterogeneity()) NEWVEC(Double, alphahat, npos());
    else alphahat = 0;
    hlod = heterogeneity() ? LOD(true) : 0;
    Output::output();
  }
}

void Linkagemodel::famline(ostream &f, Uint ifa, Uint pos) {
  fmtout(f, 9, 4, log10(LRp[ifa][pos]));
  f << "   ";
}

void Linkagemodel::totline(ostream &f, Uint pos) {
  fmtout(f, 9, 4, lod[pos]);
  if (alphahat != 0) {
    fmtout(f, 9, 4, 1.0 - alphahat[pos]);
    fmtout(f, 9, 4, hlod[pos]);
  }
  f << "   ";
}

void Linkagemodel::totheader(ostream &f) {
  if (heterogeneity())
    f << "    LOD     alpha    HLOD    ";
  else f << "    LOD    ";   
}

void Linkagemodel::famheader(ostream &f) {
  f  << "    LOD    ";
}
