#ifndef _MAP
#define _MAP
#include "basic.h"

class Infile;

class Map {
public:
  Map();              // Create empty map
  ~Map();             // Delete map
  void init(Uint N);  // initilize to N markers
  // to add info on marker number m:
  void addmarker(Uint m, Uint num_p, FloatVec p, const string &mn);
  void addpopulationfreq(Uint m, Uint popidx, Uint nump, FloatVec p);
  void adddist(FloatVec dist, int isex);  // to add intermarker distances
  Allele randomallele(Uint gam) const;
  Uint numposition;   // number of positions
  Uint num;           // number of markers, M
  vector<Uint> numallele; // numallele[m] is the number of alleles at marker m
  vector<vector<FloatVec> > pi; // population allele frequencies (array of matrices)
                              // pi[p][m][a] is the frequency of allele a+1 at 
                              // marker m in population p
  vector<IntVec> origalleles; // only used if options->printorigalleles is true
  vector<Float> theta[3];     // intermarker distances  - 0 sex avg / not sex-specif.
  vector<Float> position[3];  // positions asked for    - 1 male
  vector<Float> markerpos[3]; // positions of markers   - 2 female
  vector<string> markername;  // marker names (ids)
  vector<int> leftmarker;     // The next informative marker to the left
  vector<bool> shouldfindp;   // Should multipoint stuff be calculated at marker
  vector<bool> inbetween;     // Is position inbetween markers or at marker
  void createpos();
  void reset();

  void setunit(Unit u) {unit = u;}
  
protected:
  void readstepfile(Infile& f);
  void maxsteplength();
  void fixedstep();
  void readposfromprob();
  void allocate(Uint n);
  void deallocate();
  void start();
  Uint nsex;
  Unit unit;
};

#endif // _MAP
