#include "files.h"
#include "model.h"
#include "markermodel.h"
#include "markerdist.h"

///////////////////////////////////////////////////////////////////////////
// Markermodel

Markermodel::Markermodel(const string &markername, bool sexl, const string &p,
                         const string &of, const string &fof) :
    Linkagemodel(p) {
  setfiles(of, fof, "marker." + markername + "." + pt,
           "Marker positioning model");
  distribution = Markerdist::getmarkerdist(pt, markername, sexl);
}

void Markermodel::print() const {
  message(string("MODEL marker ") + getX() + " " +
          ((Markerdist *)distribution)->getmarkerid() + " " + pt);
}
