#include "matrix.h"
#include "probability.h"

template <>
IV Floatmatrix::numiv = 0;
template <>
IV IVmatrix::numiv = 0;
template <>
IV Intmatrix::numiv = 0;

template <>
FloatVec Matrix<Float, FloatVec>::getrow(Uint row, bool recalc) {
  if (storagetype == MEMORY || familyfitsinmemory) return x + row*numiv;
  else if (currentrow == row || !recalc) {currentrow = row; return x;}
  else {
    currentrow = row;
    if (storagetype == RECALCQ) probability->fromhere(row, x);
    else if (storagetype == RECALCLQ) probability->lqfromlqhat(row, x);
    else if (storagetype == DISK) {
      openfile(row, ios::in);
//      f->seekg(0, ios::beg);
      f->read((char *)(x VEC_GET_DATA), numiv*sizeof(Float));
      assertcond(!f->fail(), "Unable to read swapfile from disk");
      closefile();
    }
    return x;
  }
  assertinternal(false);
}

template <>
IVVec Matrix<IV, IVVec>::getrow(Uint row, bool recalc) {
  assertcond(storagetype == MEMORY || storagetype == DISK,
             "Illegal storage type for IVmatrix");
  if (storagetype == MEMORY || familyfitsinmemory) return x + row*numiv;
  else if (currentrow == row || !recalc) {currentrow = row; return x;}
  else {
    currentrow = row;
    // (storagetype == DISK)
    openfile(row, ios::in);
//    f->seekg(0, ios::beg);
    f->read((char *)(x VEC_GET_DATA), numiv*sizeof(IV));
    assertcond(!f->fail(), "Unable to read swapfile from disk");
    closefile();
    return x;
  }
  assertinternal(false);
}

template <>
IntVec Matrix<int, IntVec>::getrow(Uint row, bool recalc) {
  assertcond(storagetype == MEMORY || storagetype == DISK,
             "Illegal storage type for Intmatrix");
  if (storagetype == MEMORY || familyfitsinmemory) return x + row*numiv;
  else if (currentrow == row || !recalc) {currentrow = row; return x;}
  else {
    currentrow = row;
    // (storagetype == DISK)
    openfile(row, ios::in);
//    f->seekg(0, ios::beg);
    f->read((char *)(x VEC_GET_DATA), numiv*sizeof(int));
    assertcond(!f->fail(), "Unable to read swapfile from disk");
    closefile();
    return x;
  }
  assertinternal(false);
}
