#ifndef _MAXIMIZE
#define _MAXIMIZE
#include "basic.h"

// This module implements a hybrid of a grid search and a golden section search

class Maximizor {
public:
  typedef Double(*likelihoodfunction)(Double, Uint);
  
  Maximizor(Double xmin, Double xmax, Uint maxit, Uint gridpoints, bool oob);
  ~Maximizor();

  void maximize(Double ymin, Double xmin, likelihoodfunction fun,
                Uint posit, Double &x, Double &y);
protected:
  // It is known that fun(xmin) == ymin
  // Global constants and variables
  Double amin, amax;
  Uint maxiter, gridsize;
  DoubleVec grid;
  DoubleVec gridval;
  bool gooutofbounds;
  // Local constants and variables
  Double xmin, ymin;
  likelihoodfunction f;
  Uint pos;
  Uint niter;
  bool maximafound;
  Double astar, ystar;

  void goldenstep(Double &a1, Double &a2, Double &a3, Double a4,
                  Double &f2, Double &f3);
  void goldensearch(Double a1, Double a2, Double a4, Double f2);
  void goldenbound(Double a1, Double a4, Double f1);
  void updatemaximum(Double a, Double y);
  void goldenstart(Double a1, Double b, Double a4, Double fb);
  void goldenstart(Double a1, Double a4, Double f1);
};

#endif // _MAXIMIZE
