#ifndef _MODEL
#define _MODEL
#include "output.h"

class Distribution;

class Model : public Output {
public:
  Model(const string &p) : Output(p) {models.push_back(this);}
  virtual ~Model() {}

  static Uint modelcount() {return models.size();}
  static void printmodels();  
  static void modeloutput();

  void setdistribution(Distribution *dist) {distribution = dist;}
  const Distribution *getdistribution() const {return distribution;}
protected:
  Distribution *distribution;

  virtual const string &getfamid(Uint ifa) const;
  virtual Uint nfam() const;

  typedef vector<Model *> Modelvector;
  static Modelvector models;
};

#endif // _MODEL
