#include "files.h"
#include "distribution.h"
#include "modelweight.h"
#include "fmtout.h"
#include "family.h"
#include <fstream>

void Modelweighthodge::setninfmaff(const string &famid, Uint ninfmaff) {
  char *key = new char[famid.length() + 1];
  strcpy(key, famid.c_str());
  famid2ninfmaff[key] = ninfmaff;
}

void Modelweighthodge::initialize(Familyvector &families) {
  ofstream hf("hodge.weights");
  for (Uint ifam = 0; ifam < families.size(); ifam++) {
    Uint w = families[ifam]->hodgeninfm();
    setninfmaff(families[ifam]->id, w);
    if (w <= 1) w = 0;
    else w = w - 1;
    hf << families[ifam]->id << "\t" << w << "\t" << sqrt(double(w)) << "\n";
  }
}

Double Modelweighthodge::assign(const string &famid, Double /*std*/) const {
  String2Uint::const_iterator fn = famid2ninfmaff.find(famid.c_str());
  assertinternal(fn != famid2ninfmaff.end());
  return sqrt(max_(Double(fn->second) - 1.0, 0.0));
}

Modelweightpower::Modelweightpower(Double pwr) : power(pwr) {
  if (power == 0)
    optwarning("Illegal ASM weights specification (using equal weights)");
}

string Modelweightpower::describe() const {
  return string("power:") + Floattostring(power, 2);
}

Modelweightfile::Modelweightfile(const string &file) : filename(file) {
  const Uint MAXFAM = 2000;
  string famname[MAXFAM];
  Double wtsval[MAXFAM];
  n = 0;
  Infile wtsfile;
  wtsfile.setname(filename);
  wtsfile.optcheck("ASM weight file");
  wtsfile.open();
  while (!wtsfile.eof()) {
    wtsfile >> famname[n] >> wtsval[n] >> ws;
    optassert(wtsfile.good() || wtsfile.eof(),
              "Illegal format of ASM weight file " + wtsfile.name);
    n++;
  }
  NEWVEC(string, fam, n);
  NEWVEC(Double, wts, n);
  for (Uint i = 0; i < n; i++) {
    fam[i] = famname[i];
    wts[i] = wtsval[i];
  }
}

Double Modelweightfile::assign(const string &famid, Double /*std*/) const {
  Uint i;
  for (i = 0; i < n && famid != fam[i]; i++);
  if (i < n) return wts[i];
  else {
    optwarning("No weight found for" + famid + " in ASM weight file (using 0)");
    return 0.0;
  }
}
