#ifndef _MODELWEIGHT
#define _MODELWEIGHT
#include "basic.h"
#include "utils.h"

class Modelweight {
public:
  Modelweight() {}
  virtual ~Modelweight() {}
  virtual Double assign(const string &famid, Double std) const = 0;
  virtual string describe() const = 0;
  virtual void initialize(Familyvector &/*families*/) {}
};

class Modelweightequal : public Modelweight {
public:
  virtual Double assign(const string &/*famid*/, Double /*std*/) const
    {return 1.0;}
  virtual string describe() const {return "equal";}
};

class Modelweighthodge : public Modelweight {
protected:
  String2Uint famid2ninfmaff;

  virtual void setninfmaff(const string &famid, Uint ninfmaff);
public:
  virtual Double assign(const string &famid, Double std) const;
  virtual string describe() const {return "hodge";}
  virtual void initialize(Familyvector &families);
};

class Modelweightpower : public Modelweight {
public:
  Double power;
  Modelweightpower(Double pwr);
  virtual Double assign(const string &/*famid*/, Double std) const
    {return pow(std, power);}
  virtual string describe() const;
};

class Modelweightfile : public Modelweight {
protected:
  Uint n; //number of weights (number of rows in file)
  
  StringVec fam; //column 1: fam id's
  DoubleVec wts; //column 2: the weights
  string filename;
public:
  Modelweightfile(const string &file);
  virtual ~Modelweightfile() {DELETEVEC(fam); DELETEVEC(wts);}
  virtual Double assign(const string &famid, Double std) const;
  virtual string describe() const {return filename;}
};

#endif // _MODELWEIGHT
