#ifndef _MONTECARLO
#define _MONTECARLO
#include "basic.h"
#include "haplodist.h"

#ifdef HAVE_ZLIB
#include <zlib.h>
class ExtData;
class MarkerConfig;
#endif

class Foundercouple;

class Montecarlo : public Haplodist {
public:
  static Montecarlo *getmontecarlo(Uint size, const string &haplo,
                                   const string &inher, const string &ihaplo,
                                   const string &founder,
                                   const string &markers);
  virtual ~Montecarlo();
  virtual string describe() const {return "montecarlo";}
#ifdef DEBUG_MC
  void output(ostream &out);
#endif // DEBUG_MC

  static void setprob(Probability &p) {prob = &p;}
protected:
  Uint samplesize;
  static Probability *prob;
  Stringvector markers;
  Uintvector marker_idx;

#ifdef HAVE_ZLIB
  // output if COMPRESSHAPLOTYPES on
  gzFile zio;
  // output if HAPASSHAPLOTYPES on
  ExtData *data;
#endif
  
  Montecarlo(Uint size, const string &haplo, const string &inher,
             const string &ihaplo, const string &founder,
             const string &markers);

  virtual void printresults(const vector<IntMat> &curbits,
                            vector<IntMat> &alleles,
                            const vector<IntMat> founderalleles);

  FloatVec lq;
  bool lqreceived;
  
  IVVec d;
  vector<bool> simulated; // True if data has been simulated at marker

  class Link {
  public:
    Link() : r(0), path(0), cumsum(0), next(0) {}
    
    Float r;
    IVVec path;
    Float cumsum;
    
    Link *next;
  };
  Link *simul;

  // Male meiosis bits
  IV malemask;
  // Female meiosis bits
  IV femalemask;
  
  void setlinks();
  
  Float recfrac(Uint gam0, Uint gam1, Uint type);
  IV getfcidx(IV v, Foundercouple *fc);
  void Tfoundercouple(Float tht, FloatVec fctrans, Foundercouple *fc);
  Float Tfounder(Float tht, IV mask, IV v);
  Float Tbit(Float tht, IV mask, IV v) {return v&mask ? tht : 1 - tht;}
  Float transition(IV v, Float tht, Float tht_female = -1);
  void fillin(); // Fill in simulations for uninformative markers for current family
  void simulateend(IV gam0, IV gam1, Float tht, Float tht_female = -1);
  void simulateinbetween(IV gam0, IV gam1, IV gam2, Float tht0, Float tht1,
                         Float tht0_female = -1, Float tht1_female = -1);

#ifdef HAVE_ZLIB
  void markerconfig(MarkerConfig &config, unsigned int &fc, unsigned int &ac,
                    Uint gam, IV v);
#endif

  virtual void reset(Uint np);
  virtual void nextfam(Uint pos = 0, DoubleVec p0 = 0);
  // Perform next step in simulation, i.e. simulate v_lm | v_rm, data
  // Set gets called twice for each set of simulations, first with lq
  // and then with q
  virtual void set(FloatVec pv, Uint pos);
  virtual void skipfam() {}

};

#endif // _MONTECARLO
