#include <iomanip>
#include "files.h"
#include "output.h"
#include "options.h"
#include "fmtout.h"

Map *Output::map = 0;

void Output::output() {
  if (!outfile.is_open()) outfile.open();
  out(outfile, false);
  outfile.close();
  if (!foutfile.is_open() && (options->famfiles == OB_NOTSET && famfiles ||
                              options->famfiles == OB_ON)) foutfile.open();
  if (foutfile.is_open()) out(foutfile, true);
  if (foutfile.is_open()) foutfile.close();
}

void Output::out(ostream &f, bool famflag) {
  if (famflag) {
    f.setf(ios::left, ios::adjustfield);
    f << setw(options->maxfamidlen + 2) << "family";
  }
  f << "location";
  if (famflag) famheader(f);
  else totheader(f);
  f << "marker" << "\n";

  if (famflag)
    for (Uint fam = 0; fam < nfam(); fam++)
      lines(f, fam, famflag);
  else lines(f, Uint(-1), famflag);
}

void Output::lines(ostream &f, Uint ifa, bool famflag) {
  for (Uint pos = 0; pos < npos(); pos++) {
    if (pt == "spt" || map->inbetween[pos] ||
        map->shouldfindp[map->leftmarker[pos]]) {
      if (famflag) printfamid(f, getfamid(ifa));
      f.setf(ios::right, ios::adjustfield);
      fmtout(f, 7, 3, position(pos), 0);
      if (famflag) famline(f, ifa, pos);
      else totline(f, pos);
      f << markername(pos) << "\n";
    }
  }
}

string Output::markername(Uint pos) {
  if (pt == "mpt")
    return map->inbetween[pos] ? "-" : map->markername[map->leftmarker[pos]];
  else return map->markername[pos];
}

Float Output::position(Uint pos) {
  if (pt == "mpt") return map->position[0][pos];
  else return map->markerpos[0][pos];
}

void Output::printfamid(ostream &f, const string &fid) const {
  f.setf(ios::left, ios::adjustfield);
  f << setw(options->maxfamidlen + 2) << fid.c_str();  
}

void Output::setfiles(const string &outfn, const string &foutfn,
                      const string &defout, const string &ftype) {
  outfile.setname(outfn, defout);
  outfile.optcheck(ftype + " family file");
  string on = outfile.name;
  famfiles = foutfn != "";
  string::size_type lastslash = on.find_last_of("/");
  string fname;
  if (lastslash == string::npos) fname = "f" + on;
  else fname = (on.substr(0, lastslash + 1) + "f" + on.substr(lastslash + 1));
  foutfile.setname(foutfn, fname);
  foutfile.optcheck(ftype + " file");
}
