#ifndef _OUTPUT
#define _OUTPUT
#include <iostream>
#include "map.h"
#include "basic.h"

class Output {
protected:
  bool famfiles;
  Outfile outfile;
  Outfile foutfile;
  virtual void out(ostream &out, bool famflag);
  virtual void lines(ostream &f, Uint ifa, bool famflag);
  // *line and *header should not print the location and marker colunms
  // and fam* should not print the family column, they are handled by out
  // and lines
  virtual void totline(ostream &f, Uint pos) = 0;
  virtual void famline(ostream &f, Uint ifa, Uint pos) = 0;
  virtual void totheader(ostream &f) = 0;
  virtual void famheader(ostream &f) = 0;
  virtual const string &getfamid(Uint ifa) const = 0;
  virtual Uint nfam() const = 0;
  Uint npos() const {
    assertinternal(pt == "mpt" || pt == "spt" || pt == "dpt");
    return pt == "mpt" ? map->numposition : map->num;
  }
  string markername(Uint pos);
  Float position(Uint pos);
  void printfamid(ostream &f, const string &fid) const;
public:
  static Map *map;
  string pt;
  Output(const string &p) : famfiles(false), pt(p)
    {optassert(pt == "mpt" || pt == "spt" || pt == "dpt" || pt == "hpt" ||
               pt == "fpt",
               "Illegal point value " + pt +
               " should be either mpt, spt or dpt");}
  virtual ~Output() {}

  virtual void setfiles(const string &outfn, const string &foutfn,
                        const string &defout, const string &ftype);
  
  virtual void output();
  // prints description
  virtual void print() const = 0;
};

#endif // _OUTPUT
