#include "outputld.h"
#include "files.h"
#include "model.h"
#include "linkagedist.h"
#include "linkagemodel.h"
#include "options.h"
#include "parmodel.h"
#include "haldane.h"
#include "family.h"
#include "map.h"

const string tab = "\t";

void writepre(const string &filename, Family *firstfam, Map *m) {
  Outfile out(filename);
  out.open();
  for (Family *fam = firstfam; fam != 0; fam = fam->next) {
    for (Person *p = fam->first; p != 0; p = p->next) {
      out << fam->id << tab << p->id << tab
          << (p->father == 0 ? "0" : p->father->id) << tab
          << (p->mother == 0 ? "0" : p->mother->id) << tab
          << p->sex + 1 << tab << p->origdstat;
      for (Uint gam = 0; gam < m->num; gam++){
        out << tab;
        if (p->genotyped && p->genotyp[gam])
          out << p->gen[0][gam] << tab << p->gen[1][gam];
        else
          out << "0\t0";
      }
      out << "\n";
    }
  }
  out.close();
}

void writedat(const string &filename, Map *map) {
  Outfile out(filename);
  out.open();
  out << map->num + 1 << " 0 "
      << (options->sexlinked ? 1 : 0) << " 5" << "\n"
      << "0 0.0 0.0 0" << "\n";
  for (Uint gam = 0; gam < map->num; gam++)
    out << " " << gam + 2;
  out << "\n" << "1  2" << "\n";
  Trait *tr = Parmodel::getdefaulttrait();
  if (tr == 0) {
    out << "0.9700 0.0300" << "\n"
        << "1" << "\n"
        << "0.0900 0.9000 0.9000" << "\n";
    if (options->sexlinked)
      out << "0.0900 0.9000" << "\n";
  }
  else {
    out << tr->disfreq << " " << 1.0 - tr->disfreq << "\n"
        << "1" << "\n"
        << tr->penetrance[0][0] << " " << tr->penetrance[0][1] << " "
        << tr->penetrance[0][2] << "\n";
    if (options->sexlinked)
      out << tr->penetrance[1][0] << " " << tr->penetrance[1][1] << "\n";
  }
  for (Uint gam = 0; gam < map->num; gam++) {
    out << " 3 " << map->numallele[gam] << " # "
        << map->markername[gam] << "\n";
    for (Uint a = 0; a < map->numallele[gam]; a++)
      out << map->pi[0][gam][a] << " ";
    out << "\n";
  }
  if (options->sexspecific) {
    out << "1  0" << "\n";
    for (Uint gam = 0; gam < map->num - 1; gam++)
      out << (options->unit == RECOMBINATION ? map->theta[1][gam] :
              centimorgan(map->theta[1][gam])) << " ";
    out << "\n";
    for (Uint gam = 0; gam < map->num - 1; gam++)
      out << (options->unit == RECOMBINATION ? map->theta[2][gam] :
              centimorgan(map->theta[2][gam])) << " ";
  }
  else {
    out << "0  0" << "\n";
    for (Uint gam = 0; gam < map->num - 1; gam++)
      out << (options->unit == RECOMBINATION ? map->theta[0][gam] :
              centimorgan(map->theta[0][gam])) << " ";
  }
  out << "\n" << "1 0.10000 0.450000" << "\n";
  out.close();
}
