#ifndef _PAIRIBD
#define _PAIRIBD
#include "basic.h"
#include "pairwise.h"

class Person;

class IBDperson : public Pairwiseperson<Indexfounderallele> {
protected:
  bool informative;
  DoubleVec ibd1;
  DoubleVec ibd2;

  Uint index;
  Uint numibd;
  void updateibd(Double curprob);
public:
  IBDperson(Person *p, IBDperson *first, Uint lastrel, Uint &idx, bool inf);
  ~IBDperson();
  
  Double calcpairibd(IV v, IV mask, DoubleVec prob = 0);
  void collectpairs(IBDperson *first,
                    StringVec person1, StringVec person2) const;
  void collectresults(IBDperson *first,
                      DoubleVec results1, DoubleVec results2, Double nc) const;
  void correctfoundercouple(Uint gfidx, Uint gmidx);
  void reset();
  Uint get_index() const {return index;}
  Uint countpairs(IBDperson *first) const;
  IBDperson *findperson(Person *p);
  void getsharing(IBDperson *p, Float &p1, Float &p2);
};

#endif // _PAIRIBD
