#ifndef _PAIRWISE
#define _PAIRWISE
#include "basic.h"

class Indexfounderallele {
public:
  UintVec descendants;
  BoolVec descendanthomozygous;
  Uint numdescendants;
  
  Indexfounderallele() : numdescendants(0) {}
  void setmaxnum(Uint maxnum) {
    if (maxnum > 0) {
      NEWVEC(Uint, descendants, maxnum);
      NEWVEC(bool, descendanthomozygous, maxnum);
    }
    else {
      descendants = 0;
      descendanthomozygous = 0;
    }
  }
  ~Indexfounderallele()
    {DELETEVEC(descendants); DELETEVEC(descendanthomozygous);}
  
  void pushdescendant(Uint idx, bool homozygote) {
    descendants[numdescendants] = idx;
    descendanthomozygous[numdescendants++] = homozygote;
  }
  void popdescendant() {numdescendants--;}
};

template <class Founderallele>
class Pairwiseperson {
protected:
  Person *per;
  Pairwiseperson *father;
  Pairwiseperson *mother;
public:
  Pairwiseperson *next;
  Founderallele *nod[2];
  Pairwiseperson(Person *p, Pairwiseperson *first) :
      per(p), father(0), mother(0), next(0) {
    if (p->founder()) {
      nod[0] = new Founderallele;
      nod[1] = new Founderallele;
    }
    else nod[0] = nod[1] = 0;
    
    Pairwiseperson *last = 0;
    for (Pairwiseperson *q = first; q != 0; q = q->next) {
      if (q->per == per->father) father = q;
      if (q->per == per->mother) mother = q;
      last = q;
    }
    if (last != 0) last->next = this;
  }
  ~Pairwiseperson() {
    if (per->founder()) {
      delete nod[0];
      delete nod[1];
    }
    delete next;
  }
};

#endif // _PAIRWISE
