#include "files.h"
#include "linkagedist.h"
#include "paramdist.h"
#include "family.h"

///////////////////////////////////////////////////////////////////////
// Paramdist

Paramdist *Paramdist::getparamdist(const string &pt, Trait *tr) {
  Calcparametric *calcparametric = Calcparametric::getcalcparametric(tr);
  Distribution *dist =
    Distribution::finddistribution(calcparametric->describe(), pt);
  if (dist != 0) return (Paramdist *)dist;
  else return new Paramdist(pt, calcparametric);
}

bool Paramdist::usefamily(Family *fam) const {
  Uint ninf = 0;
  for (Person *p = fam->first; p != 0; p = p->next) 
    if (p->dstat != UNKNOWN) ninf++;
  return ninf > 1 && fam->numbits > 0;
}
