#ifndef _PARAMDIST
#define _PARAMDIST
#include "basic.h"
#include "calcparametric.h"

class Trait;

class Paramdist : public Linkagedist {
public:
  virtual ~Paramdist() {}

  static Paramdist *getparamdist(const string &pt, Trait *tr);

  void settrait(Trait *tr) {getcalcparametric().settrait(tr);}
  Trait *gettrait() {return getcalcparametric().gettrait();}

  // Family if used if it is more than 0 bits and has more than two or more
  // people that are affected or unaffected
  virtual bool usefamily(Family *fam) const;
protected:
  Paramdist(const string &p, Calclinkage *clc) : Linkagedist(p, clc) {}

  inline const Calcparametric &getcalcparametric() const
    {return *((Calcparametric *)calclinkage);}
  inline Calcparametric &getcalcparametric()
    {return *((Calcparametric *)calclinkage);}
};

#endif // _PARAMDIST
