#include "files.h"
#include "model.h"
#include "linkagemodel.h"
#include "linkagedist.h"
#include "parmodel.h"
#include "peel.h"

///////////////////////////////////////////////////////////////////
// Parmodel

Trait *Parmodel::defaulttrait = 0;

Parmodel::Parmodel(const string &pt, bool het, const string& of,
                   const string& fof, Double f,
                   Double p0, Double p1, Double p2,
                   Double p0_male, Double p1_male) :
    Linkagemodel(pt), heterogen(het) {
  setfiles(of, fof,  "param." + pt, "parametric output");
  Trait *trait = 0;
  if (p0 != -1) {
    if (p0_male == -1) trait = new Trait(f, p0, p1, p2, false);
    else {
      trait = new Trait(2, f, true);
      trait->penetrance[0][0] = p0;
      trait->penetrance[0][1] = p1;
      trait->penetrance[0][2] = p2;
      trait->penetrance[1][0] = p0_male;
      trait->penetrance[1][1] = p1_male;
    }
  }
  distribution = Paramdist::getparamdist(pt, trait);
}

void Parmodel::print() const {
  string out = "MODEL " + pt + " ";
  Paramdist *paramdist = (Paramdist *)distribution;
  out += paramdist->describe();
  message(out + " " + outfile.name + " " + foutfile.name);
}

void Parmodel::setdefaulttrait(Trait *tr) {
  defaulttrait = tr;
  for (Uint m = 0; m < models.size(); m++) {
    string did = models[m]->getdistribution()->describe();
    if (did.substr(0, 3) == "par") {
      Parmodel *pm = (Parmodel *)models[m];
      if (((Paramdist *)pm->distribution)->gettrait() == 0)
        pm->settrait(tr);
    }
  }
}
