#ifndef _PEEL
#define _PEEL
#include "trait.h"
#include "family.h"

////////////////////////////////////////////////////////////////
// Genereal linked list class

template <class T> 
class Llist {
private:
  Llist **prev;

public:
  T *val;
  Llist *next;

  Llist(T *v, Llist **p, Llist *n = 0) : prev(p), val(v), next(n)
    {if (next != 0) next->prev = &this->next; *prev = this;}
  ~Llist() {*prev = next; if (next != 0) next->prev = prev;}
  //  void remove() {*prev = next;}
  void insertafter(T *v) {new Llist(v, &next, next);}
  T *operator->() const {return val;}
};

////////////////////////////////////////////////////////////////
// Elston-Stewart type graph representation of pedigrees

class ESmarriage;
class ESperson;
class ESgraph;
typedef Llist<ESperson> ESchildren;
typedef Llist<ESperson> ESpeople;
typedef Llist<ESmarriage> ESmarriages;

class ESperson {
public:
  ESmarriage *parmar;
  ESmarriages *mar;
  Person *per;
  bool split;
  bool flag;

  // Peeling data
  int ngt;          // How many genotypes are possible, either 2 (d, D) or
                    // 4 (dd, dD, Dd, DD)
  int peelcount;    // Counts how many times this person gets peeled
                    // onto
  DoubleVec finalprob;
  DoubleMat peelprob;
  
  ESperson(Person *p);
  ~ESperson() {DELETEMAT(peelprob);}
  void addparentalmarriage(ESgraph &g);
  ESmarriage *marriedto(ESperson *spouse) const;
  void removemarriage(ESmarriage *m);
  bool hasloops(ESmarriage *caller);
  inline int allelesfromparents(IV v, int f, int m) const;
  inline int allelefrommother(IV v, int m) const 
    {return (v & per->matmask ? m%2 : m/2);}
  inline bool isleaf() const;
  bool uninformativedstat()
    {return per->dstat != AFFECTED && per->dstat != UNAFFECTED;}
};

class ESmarriage {
public:
  ESperson *husband;
  ESperson *wife;
  ESchildren *child;
  IV bitmask;       // Bitmask for the bits in the inheritance vector 
                    // belonging to this marriage
  int bitcount;     // Counts how many bits in inheritance vector belong
                    // to children of this marriage
  bool ripe;        // Flag used during creation of peeling order
  bool peeled;      // true if this marriage has already been added to 
                    // peelorder
  
  ESmarriage(ESperson *h, ESperson *w, ESperson *c = 0);
  bool hasloops(ESperson *caller);
  bool isripe() const;
  void addchild(ESperson *c);
};

class Peelaction;

class ESgraph {
protected:
  ESpeople *first;
  ESmarriages *firstmar;
  Peelaction *peelorder;
  Peelaction *lastpeel;
  Trait *trait;
  IV numiv;
  IV bitmask;
  
  void trimuninformative();
  void removeperson(ESperson *p);
  void createpeelorder();
  void addpeel(Peelaction *p);
  void initializeprob();
public:
  ESgraph() {};
  ESgraph(Family &fam, Trait *t);
  bool hasloops() const {return first->val->hasloops(0);};
  ESperson *findperson(Person *p) const;
  void addmarriage(ESmarriage *m) 
    {firstmar = new ESmarriages(m, &firstmar, firstmar);}
  void peel(DoubleVec S);
};

////////////////////////////////////////////////////////////////
// Peeling utility classes

class Peelaction {
public:
  Peelaction *next;

  Peelaction(Peelaction *n = 0) : next(n) {}; 

  virtual void perform(IV v) = 0;
  virtual ostream &write(ostream &stream) = 0;
  friend ostream &operator<<(ostream &stream, Peelaction &pa) 
    {return pa.write(stream);}
};

class Peelbit : public Peelaction {
public:
  IV bit;
  
  virtual void perform(IV v);
  virtual ostream &write(ostream &stream) 
    {return stream << this << " Peelbit " << bit << endl;}
};

class Peeldone : public Peelaction {
public:
  ESperson *last;
  DoubleVec L;

  virtual void perform(IV v);
  virtual ostream &write(ostream &stream) 
    {return stream << this <<  "Peeldone " << last->per->id << endl;}
};

class Peel2 : public Peelaction {
public:
  ESperson *proband;
  
  int probandpeelnumber;
};

class Peelloop : public Peel2 {
public:
  virtual void perform(IV v);
  virtual ostream &write(ostream &stream) 
    {return stream << this << " Peelloop " << proband->per->id << "  " 
		   << probandpeelnumber << " *" << proband << endl;}
};

class Peelmarriage : public Peel2 {
public:
  ESmarriage *marriage;
};
  
class Peel2parent : public Peelmarriage {
public:
  virtual void perform(IV v);
  virtual ostream &write(ostream &stream) 
    {return stream << this << " Peel2parent " << proband->per->id << "  " 
		   << probandpeelnumber << " *" << proband << endl;}
};

class Peel2child : public Peelmarriage {
public:
  virtual void perform(IV v);
  virtual ostream &write(ostream &stream) 
    {return stream << this << " Peel2child " << proband->per->id << "  " 
		   << probandpeelnumber << " *" << proband << endl;}
};

#endif // _PEEL
