#include <fstream>
#include "matrix.h"
#include "probability.h"
#include "files.h"
#include "options.h"
#include "map.h"
#include "vecutil.h"
#include "family.h"

Graph *Probability::graph = 0;

Probability::Probability(Floatmatrix *qp, Floatmatrix *lqp,
                         Floatmatrix *lqhatp, FloatVec rqhatp,
                         Family *f, Map *mp) {
  fam = f;
  numbits = fam->numbits;
  map = mp;
  q = qp;
  lq = lqp;
  lqhat = lqhatp;
  rqhat = rqhatp;
  wtstar = 0;
  wtstar_female = 0;
  graph = 0;
  numiv = fam->numiv;
  createmasks();
  createweight();
  createfoundergraph();
  informative.resize(map->num);
  theta.resize(map->num - 1);
  theta_female.resize(map->num - 1);

  leftmarker.resize(map->numposition, 0);
  rightmarker.resize(map->numposition, 0);

  NEWVEC(Float, l_nc, map->num);
  copyval(l_nc, 1.0, map->num);
  // Flattening factor
  ifstream ff("r.txt", ios::in);
  if (ff != 0) ff >> r;
  else r = 1.0;
}

Probability::~Probability() {
  DELETEVEC(l_nc);
}

void Probability::ignoreuninformative() {
  // This function is only called for informative families
  Uint gam = 0;
  int lastinformative = NOLEFTMARKER;
  // Find next informative marker to the left and calculate thetas
  for (Uint pos = 0; pos < map->numposition; pos++) {
    if (!map->inbetween[pos]) {
      if (informative[gam]) lastinformative = gam;
      gam++;
    }
    leftmarker[pos] = lastinformative;
  }
//  if (lastinformative == NOLEFTMARKER)
//    warning(fam->id + " has no informative markers!");
//  else {
    // Find next informative marker to the right
  lastinformative = NORIGHTMARKER;
  gam = map->num - 1;
  for (int pos = map->numposition - 1; pos >= 0; pos--) {
    rightmarker[pos] = lastinformative;
    if (!map->inbetween[pos]) {
      if (informative[gam]) lastinformative = gam;
      gam--;
    }
  }
//  }
}

void Probability::addbit(IV &j, IV &partransmask, IV &parmask) {
  j >>= 1;
  assertinternal(j != 0);
  partransmask = j;
  parmask |= j;
}

void Probability::createmasks() {
  // First clean masks
  fam->mask = 0;
  for (Person *p = fam->first; p != 0; p = p->next)
    p->patmask = p->matmask = p->mask = p->lastbit = 0;
  for (Foundercouple *fc = fam->firstfoundercouple; fc != 0; fc = fc->next)
    fc->mask = fc->childrenmask = fc->lastgcbit = fc->bitbeforefirstgcbit = 0;
  IV j = numiv;
  // First come the bits belonging to children of the foundercouple
  for (Foundercouple *fc = fam->firstfoundercouple; fc != 0; fc = fc->next) {
    for (Plist *c = fc->wife->children; c != 0; c = c->next) {
      if (!c->p->removematbit)
        addbit(j, c->p->matmask, c->p->mother->founder() ?
               c->p->mother->mask : fam->mask);
    }
    fc->wife->lastbit = j;
    for (Plist *c = fc->husband->children; c != 0; c = c->next) {
      if (!c->p->removepatbit) 
        addbit(j, c->p->patmask, c->p->father->founder() ?
               c->p->father->mask : fam->mask);
    }
    fc->husband->lastbit = j;
    fc->childrenmask = fc->husband->mask | fc->wife->mask;
  }
  
  // Then come the bits belonging to other children of founders
  for (Person *p = fam->first; p != fam->firstdescendant; p = p->next) {
    if (p->mask == 0) {
      for (Plist *c = p->children; c != 0; c = c->next) {
        if (p->sex == FEMALE && !c->p->removematbit && c->p->matmask == 0)
          addbit(j, c->p->matmask, p->founder() ? p->mask : fam->mask);
        if (p->sex == MALE && !c->p->removepatbit && c->p->patmask == 0) 
          addbit(j, c->p->patmask, p->founder() ? p->mask : fam->mask);
      }
      p->lastbit = j;
    }
  }
  fam->lastfounderbit = j;

  // Then come the bits belonging to grandchildren of the foundercouple
  for (Foundercouple *fc = fam->firstfoundercouple; fc != 0; fc = fc->next) {
    fc->bitbeforefirstgcbit = j;
    if (fc->bitbeforefirstgcbit == 0) fc->bitbeforefirstgcbit = 1;
    for (Plist *c = fc->husband->children; c != 0; c = c->next) 
      for (Plist *g = c->p->children; g != 0; g = g->next) {
        if (!g->p->removematbit && c->p->sex == FEMALE)
          addbit(j, g->p->matmask, fc->mask);
        if (!g->p->removepatbit && c->p->sex == MALE) 
          addbit(j, g->p->patmask, fc->mask);
      }
    if (fc->mask != 0) fc->lastgcbit = j;
    else fc->lastgcbit = 1;
  }
  
  // Finally come the bits belonging to other children of non-founders
  for (Person *p = fam->firstdescendant; p != 0; p = p->next) {
    for (Plist *c = p->children; c != 0; c = c->next) {
      if (p->sex == FEMALE && !c->p->removematbit && c->p->matmask == 0)
        addbit(j, c->p->matmask, p->founder() ? p->mask : fam->mask);
      if (p->sex == MALE && !c->p->removepatbit && c->p->patmask == 0) 
        addbit(j, c->p->patmask, p->founder() ? p->mask : fam->mask);
    }
  }
  assertcond(j == 1, "Unable to assign all bits in family " + fam->id);
}

void Probability::createweight() {
  wtstar = new unsigned char[numiv];
  if (options->sexspecific) {
    wtstar_female = new unsigned char[numiv];
    IV malemask = 0;
    IV femalemask = 0;
    for (Person *p = fam->firstdescendant; p != 0; p = p->next) {
      IV mask = 0;
      for (Plist *c = p->children; c != 0; c = c->next)
        mask |= (p->sex == MALE ? c->p->patmask : c->p->matmask);
      if (p->sex == MALE) malemask |= mask;
      else femalemask |= mask;
    }
    for (IV v = 0; v < numiv; v++) {
      wtstar[v] = wt[v & malemask];
      wtstar_female[v] = wt[v & femalemask];
    }
    for (Person *p = fam->first; p != fam->firstdescendant; p = p->next)
      if (p->mask != 0) {
        unsigned char *wts = (p->sex == MALE ? wtstar : wtstar_female);
        for (IV v = 0; v < numiv; v++) {
          unsigned char weight = wt[v & p->mask];
          wts[v] += (weight & 1) ? weight + 1 : weight;  
        }
      }
  }
  else {
    for (IV v = 0; v < numiv; v++) wtstar[v] = wt[v & fam->mask];
    for (Person *p = fam->first; p != fam->firstdescendant; p = p->next)
      if (p->mask != 0) {
        for (IV v = 0; v < numiv; v++) {
          unsigned char weight = wt[v & p->mask];
          wtstar[v] += (weight & 1) ? weight + 1 : weight;  
        }
      }
    for (Foundercouple *fc = fam->firstfoundercouple; fc != 0; fc = fc->next)
      if (fc->mask != 0)
        for (IV v = 0; v < numiv; v++)
          wtstar[v] += wt[v & fc->mask];
  }
}

//  Float Probability::pdatahere(int gam, FloatVec p) {
//  //  Float sumq = sum((*q)[gam], numiv);
//  //   Float sump = sum(p, numiv);
//  //   elemprod(l[gam], l[gam], r, numiv);
//  //   Float sumlr = sum(l[gam], numiv);
//  //   return Float(numiv)*sump/(sumq*sumlr);
//    return 1.0;
//  }

Float Probability::fromhere(Uint gam, FloatVec q) {
  Float nc = fromhere(gam, q, map->pi[fam->populationindex][gam], fam);
  checkq(gam);
  return nc;
}
