#ifndef _PROBABILITY
#define _PROBABILITY
#include "basic.h"
#include "matrix.h"

class Graph;
class Foundercouple;
class Plist;

class Probability {
public:
  static const int NOLEFTMARKER = -1;
  static const int NORIGHTMARKER = -1;

  Probability(Floatmatrix *qp, Floatmatrix *lqp, Floatmatrix *lqhatp,
              FloatVec rqhatp, Family *f, Map *mp);
  ~Probability();
  Floatmatrix *q;
  Floatmatrix *lq;
  Floatmatrix *lqhat;   // hat(l . q), previously hat(M_{gamma,L}^+)
  FloatVec rqhat;
  FloatVec l_nc; // Normalizing constant for l at each marker
  vector<bool> informative;  // true if marker is informative
  Uint numiv;         // number of inheritance vectors, N (N = 2^n)
  
  void findp(Uint pos, FloatVec p);
  Float fromhere(Uint gam, FloatVec q);
  // calculate q
  static Float fromhere(Uint gam, FloatVec q, FloatVec freq, Family *fam);
  void createfoundergraph();
  void deletefoundergraph();
  void check(const string &s, int gam, FloatVec d, Float tht = .5, Float *L = 0);
  void lqfromlqhat(int gam, FloatVec lq);
  void ignoreuninformative();
  void findlq(FloatVec lqhatlast, FloatVec lqhat, FloatVec lq, FloatVec q,
              Uint lastinformative, Uint gam, Float &L);
  void finddpt(Uint pos, FloatVec r);
  void markuninformative(Uint gam);  // marks a marker as uninformative
  Uint numbits;       // length of inheritance vector, n (n = 2*m-f)
  vector<int> leftmarker; // The next informative marker to the left
  vector<int> rightmarker; // The next informative marker to the right
  vector<Float> theta; // The recomb fraction between each informative marker
                       // and the next one
  vector<Float> theta_female; // same for females in sex-specific case
  static Graph *graph; // graph used for M_gamma calculation
  // Fouriertransform of T
  void Ttrans(FloatVec D, FloatVec S, Float tht,
              Float tht_male, Float tht_female); 
private:
  static void outputvec(ostream& str, int gam, FloatVec x, Uint N);
  void addbit(IV &j, IV &partransmask, IV &parmask);
  void createmasks();    // used by Fouriertransform of T
  void createweight();   // also used by Fouriert. of T
  void startright(int gam);
  void calculatefctrans(FloatVec D, FloatVec S, Float tht);
  void fcinnerprod(FloatVec D, FloatVec S, Float tht, IV a, IV b, Foundercouple* fc);
  bool checkq(Uint gam); // Checks if marker is all 0 or
                         // noninformative
  void flattenq(int gam, Float r);
  void mrktopos(FloatVec posdist, FloatVec mrkhat, Uint gam, Uint pos);
  static void findq(Plist* p, FloatVec M, int gam, IV v, Graph *graph);
//  Float pdatahere(int gam, FloatVec p); // Caluclates the probability of single
                                      // locus data, given the data from left
                                      // and right

  Float r; // Flattening factor
  IV mask;    // mask for nonfounder meioses
  Float factors[2*MAXBITS];
  Float factors_female[2*MAXBITS];
  // weights for Fourier transform of T
  unsigned char *wtstar; // weights for male meioses in sex-specific case
  unsigned char *wtstar_female; // weights for female meioses in sex-spec case
  Family *fam;          // associated family
  Map *map;             // family map
};

#endif // _PROBABILITY
