#ifndef _QTLMODEL
#define _QTLMODEL
#include "basic.h"
#include "model.h"
#include "findnormal.h"
#include "bfgs.h"
#include "maximize.h"

class QTLmodel : public Model {
protected:
  FindNormalLoglik loglik;

  bool conditionallikelihood;

  bool maximizeS;
  bool maximizeG;
  bool maximizeA;
  bool maximizeD;
  Double shared;
  Double resid;
  
  DoubleVec lod;
  Double Snullhat;
  Double Gnullhat;
  DoubleVec Shat;
  DoubleVec Ghat;
  DoubleVec Ahat;
  DoubleVec Dhat;
  DoubleMat flod;
  DoubleVec p;
  DoubleVec L;

  void calculateL(Family *fam, DoubleVec L,
                  Double S, Double G, Double A, Double D);

  void initialize();
  virtual void run();
  virtual Double calculate(DoubleVec fl, Double S,
                           Double G, Double A, Double D, Uint gam);
  
  friend Double maxfunc_G(Double G, Uint gam);
  friend Double maxfunc_A(Double A, Uint gam);
  friend Double maxfunc_D(Double D, Uint gam);
  friend Double minfunc_GA(DoubleVec x, Uint gam);
  friend Double minfunc_GD(DoubleVec x, Uint gam);
  friend Double minfunc_AD(DoubleVec x, Uint gam);
  friend Double minfunc_GAD(DoubleVec x, Uint gam);
  friend Double maxfunc_S(Double S, Uint gam);
  friend Double minfunc_SG(DoubleVec x, Uint gam);
  friend Double minfunc_SA(DoubleVec x, Uint gam);
  friend Double minfunc_SD(DoubleVec x, Uint gam);
  friend Double minfunc_SGA(DoubleVec x, Uint gam);
  friend Double minfunc_SGD(DoubleVec x, Uint gam);
  friend Double minfunc_SAD(DoubleVec x, Uint gam);
  friend Double minfunc_SGAD(DoubleVec x, Uint gam);

  void univariatemaximization(DoubleVec xhat, Double xmax,
                              DoubleVec fhat, Double fmin,
                              Maximizor::likelihoodfunction fun, Uint numpos);
  void bivariatemaximization(DoubleVec xhat, Double xmax, DoubleVec yhat,
                             Double ymax, DoubleVec fhat,
                             BFGS::Trianglefunction fun, Uint numpos);
  void trivariatemaximization(DoubleVec xhat, Double xmax,
                              DoubleVec yhat, Double ymax,
                              DoubleVec zhat, Double zmax,
                              DoubleVec fhat, BFGS::Trianglefunction fun,
                              Uint numpos);
  void quadvariatemaximization(DoubleVec shat, DoubleVec xhat,
                               DoubleVec yhat, DoubleVec zhat, 
                               DoubleVec fhat, BFGS::Trianglefunction fun,
                               Uint numpos);
  
  virtual void totline(ostream &f, Uint pos);
  virtual void famline(ostream &f, Uint ifa, Uint pos);
  virtual void totheader(ostream &f);
  virtual void famheader(ostream &f);  
public:
  QTLmodel(const string &p, bool condlik, bool maxG, bool maxA, bool maxD,
           Double res = -1, Double shr = -1) :
      Model(p), conditionallikelihood(condlik), maximizeS(false),
      maximizeG(maxG), maximizeA(maxA), maximizeD(maxD), resid(res),
      shared(shr), lod(0), Shat(0), Ghat(0), Ahat(0), Dhat(0), flod(0), p(0),
      L(0) {}
  virtual ~QTLmodel();

  virtual void output();
};

#endif // _QTLMODEL
