#ifndef _RECOMB
#define _RECOMB
#include "basic.h"
#include "matrix.h"
#include "output.h"
#include "vecutil.h"
#include "options.h"

class Recomb : public Output {
public:
  Recomb(const string &of, const string &fof);
  void setlqhat(Floatmatrix* lqh) {lqhat = lqh;}
  virtual ~Recomb();
  void nextfam(Family *f);
  void finishfam();
  void calc(FloatVec Fp, FloatVec rqh, Uint gam, Float theta,
            Float theta_female = -1);
  void skipcurfam();
  virtual void print() const;
  void reset();
protected:
  Uint numbits;
  int lastcalcmarker; // Last calculated marker no. or - 1
  Floatmatrix *lqhat;
  Family *fam;
  
  class Familydata {
  protected:
    Uint npos;
  public:
    Familydata(Family *f, Uint np) : npos(np), fam(f) {
      NEWVEC(Double, recomb, npos);
      copyval(recomb, -1, npos);
      NEWVEC(Double, xover, npos);
      if (options->sexspecific) {
        NEWVEC(Double, recomb_female, npos);
        copyval(recomb_female, -1, npos);
        NEWVEC(Double, xover_female, npos);
      }
    }
    Familydata(const Familydata &fd) : npos(fd.npos), fam(fd.fam) {
      NEWVEC(Double, recomb, npos);
//      copyval(recomb, -1, npos);
      NEWVEC(Double, xover, npos);
      if (options->sexspecific) {
        NEWVEC(Double, recomb_female, npos);
//        copyval(recomb_female, -1, npos);
        NEWVEC(Double, xover_female, npos);
      }
     }
    ~Familydata() {
      DELETEVEC(recomb);
      DELETEVEC(xover);
      if (options->sexspecific) {
        DELETEVEC(recomb_female);
        DELETEVEC(xover_female);
      }
    }
    Family *fam;
    FloatVec recomb;
    FloatVec recomb_female;
    FloatVec xover;
    FloatVec xover_female;
    Uint nbits;
    Uint nbits_male;
    Uint nbits_female;
    Uint numsc;
    Uint numsc_male;
    Uint numsc_female;
  };
  typedef vector<Familydata *> Familydatavector;
  Familydatavector familydata;
  
  FloatVec thfactor;
  FloatVec thpower;
  FloatVec thf;    // Points to middle of thfactor;
  FloatVec thp;
  FloatVec thfactor_female;
  FloatVec thpower_female;
  FloatVec thf_female;    // Points to middle of thfactor_female;
  FloatVec thp_female;
  FloatVec F;
  FloatVec rqhat;
  Double totxover;
  Double totxover_female;
  Double totdistance;
  Double totdistance_female;
  Uint bitsum;
  Uint bitsum_male;
  Uint bitsum_female;
  IV mask_male;
  IV mask_female;
  void addtosum(Double& sum, Double& C, Double prod, Double count, IV r,
                Person *f, IV maskJ, IV masknotJ, Uint nJ);
  void addtosum_sexspecific(Double& sum_male, Double& sum_female,
                            Double& C, Double prod, Double count_male,
                            Double count_female, IV r, Person *f);
  void addtosum_sexlinked(Double& sum, Double& C, Double prod,
                          Double count, IV r, Person *f);
  void fcaddtosum(Double& sum, Double& C, Foundercouple *fc, BoolVec J,
                  Uint iJ, IV maskJ, IV masknotJ, Uint nJ, Uint gam);
  void calcFpi(BoolVec J);
//  void fillin(Uint ml, Uint mr);
  void fillin(const vector<Float> &theta, const vector<Float> &markerpos,
              FloatVec rec, Uint n, Uint ml, Uint mr);
  void calcxovers();
  static Float recombtoxovers(Float theta, Float rec, Uint nb, Uint nsc);
  virtual void lines(ostream &f, Uint ifa, bool famflag);
  virtual void totline(ostream &f, Uint pos);
  virtual void famline(ostream &f, Uint ifa, Uint pos);
  virtual void totheader(ostream &f);
  virtual void famheader(ostream &f);
  void createfj(Plist *c, Foundercouple *fc, BoolVec J, Uint iJ, IV r, IV pir);
  void createfjrest(IV lastfcbit, IV r, IV pir);
  virtual const string &getfamid(Uint ifa) const
    {assertinternal(ifa < familydata.size()); return familydata[ifa]->fam->id;}
  virtual Uint nfam() const {return familydata.size();}
};

#endif // _RECOMB
