#ifndef _RECOMBDIST
#define _RECOMBDIST
#include "basic.h"
#include "vecutil.h"
#include "options.h"
#include "distribution.h"

class Plist;
class Foundercouple;

class Recombdist : public Distribution {
public:
  static Recombdist *getrecombdist();
  
  virtual ~Recombdist();
  static void set(FloatVec Fp, FloatVec rqh, FloatVec lqh, Uint gam,
                  Float theta, Float theta_female, const string &pt);

  void calcxovers();
  
  Uint bitsum_male() const;
  Uint bitsum_female() const;
  Uint nbits(Uint ifa) const {return familydata[ifa]->nbits;}
  Uint nbits_male(Uint ifa) const {return familydata[ifa]->nbits_male;}
  Uint nbits_female(Uint ifa) const {return familydata[ifa]->nbits_female;}
  Float xoversum(Uint pos) const;
  Float xoversum_female(Uint pos) const;
  Float xover(Uint ifa, Uint pos) {return familydata[ifa]->xover[pos];}
  Float xover_female(Uint ifa, Uint pos)
    {return familydata[ifa]->xover_female[pos];}
  virtual string describe() const {return "recomb";}
protected:
  Recombdist();

  virtual void set(FloatVec Fp, FloatVec rqh, FloatVec lqh, Uint gam,
                   Float theta, Float theta_female);
  
  virtual void reset(Uint np);
  virtual void nextfam(Uint pos = 0, DoubleVec p0 = 0);
  virtual void set(FloatVec, Uint /*pos*/) {assertinternal(false);}
  virtual void skipfam();

  Uint numbits;
  int lastcalcmarker; // Last calculated marker no. or - 1
  
  class Familydata {
  protected:
    Uint npos;
  public:
    Familydata(Uint np) : npos(np) {
      NEWVEC(Double, recomb, npos);
      copyval(recomb, -1, npos);
      NEWVEC(Double, xover, npos);
      if (options->sexspecific) {
        NEWVEC(Double, recomb_female, npos);
        copyval(recomb_female, -1, npos);
        NEWVEC(Double, xover_female, npos);
      }
    }
    Familydata(const Familydata &fd) : npos(fd.npos) {
      NEWVEC(Double, recomb, npos);
      NEWVEC(Double, xover, npos);
      if (options->sexspecific) {
        NEWVEC(Double, recomb_female, npos);
        NEWVEC(Double, xover_female, npos);
      }
     }
    ~Familydata() {
      DELETEVEC(recomb);
      DELETEVEC(xover);
      if (options->sexspecific) {
        DELETEVEC(recomb_female);
        DELETEVEC(xover_female);
      }
    }
    FloatVec recomb;
    FloatVec recomb_female;
    FloatVec xover;
    FloatVec xover_female;
    Uint nbits;
    Uint nbits_male;
    Uint nbits_female;
    Uint numsc;
    Uint numsc_male;
    Uint numsc_female;
  };
  typedef vector<Familydata *> Familydatavector;
  Familydatavector familydata;

  FloatVec thfactor;
  FloatVec thpower;
  FloatVec thf;    // Points to middle of thfactor;
  FloatVec thp;
  FloatVec thfactor_female;
  FloatVec thpower_female;
  FloatVec thf_female;    // Points to middle of thfactor_female;
  FloatVec thp_female;
  FloatVec F;
  FloatVec rqhat;
  FloatVec lqhat;

  IV mask_male;
  IV mask_female;

  void addtosum(Double& sum, Double& C, Double prod, Double count, IV r,
                Person *f, IV maskJ, IV masknotJ, Uint nJ);
  void addtosum_sexspecific(Double& sum_male, Double& sum_female,
                            Double& C, Double prod, Double count_male,
                            Double count_female, IV r, Person *f);
  void addtosum_sexlinked(Double& sum, Double& C, Double prod,
                          Double count, IV r, Person *f);
  void fcaddtosum(Double& sum, Double& C, Foundercouple *fc, BoolVec J,
                  Uint iJ, IV maskJ, IV masknotJ, Uint nJ, Uint gam);
  void calcFpi(BoolVec J);
  void fillin(const vector<Float> &theta, const vector<Float> &markerpos,
              FloatVec rec, Uint n, Uint ml, Uint mr);
  static Float recombtoxovers(Float theta, Float rec, Uint nb, Uint nsc);
  void createfj(Plist *c, Foundercouple *fc, BoolVec J, Uint iJ, IV r, IV pir);
  void createfjrest(IV lastfcbit, IV r, IV pir);

  virtual void writeprob(const Map &/*mp*/) {}
  virtual void readprob(Infile& /*f*/) {}
  virtual void writenull() {}
  virtual void readnull(Infile& /*f*/) {}
};

#endif // _RECOMBDIST
