#include <iostream>
#include <fstream>
#include <iomanip>
#include "files.h"
#include "recombmodel.h"
#include "fmtout.h"
#include "recombdist.h"
#include "haldane.h"

Recombmodel::Recombmodel(const string &of, const string &fof) : Model("spt") {
  setfiles(of, fof, "xover.dat", "crossoverrate output");
  distribution = Recombdist::getrecombdist();
}

void Recombmodel::lines(ostream &f, Uint ifa, bool famflag) {
  totxover = totdistance = 0.0;
  bitsum_male = ((Recombdist *)distribution)->bitsum_male();
  bitsum_female = ((Recombdist *)distribution)->bitsum_female();
  bitsum = (options->sexlinked ? 0 : bitsum_male) + bitsum_female;

  for (Uint pos = 0; pos < npos() - 1; pos++) {
    if (map->shouldfindp[map->leftmarker[pos]]) {
      if (famflag) printfamid(f, getfamid(ifa));
      f.setf(ios::right, ios::adjustfield);
      fmtout(f, 7, 3, position(pos), 0);
      if (famflag) famline(f, ifa, pos);
      else totline(f, pos);
      f << markername(pos) << "\n";
    }
  }
  if (famflag) printfamid(f, getfamid(ifa));
  f.setf(ios::right, ios::adjustfield);
  Uint nb = famflag ? ((Recombdist *)distribution)->nbits(ifa) : bitsum;
  f << "Total: ";
  if (options->sexspecific) {
    fmtout(f, 9, 3, totdistance);
    fmtout(f, 6 + options->xoverrateprecision, options->xoverrateprecision,
           (bitsum_male > 0 ? totxover/bitsum_male*100.0 : 0));
    f << setw(7) << bitsum_male;
    fmtout(f, 9, 3, totdistance_female);
    fmtout(f, 6 + options->xoverrateprecision, options->xoverrateprecision,
           (bitsum_female > 0 ? totxover_female/bitsum_female*100.0 : 0));
    f << setw(7) << bitsum_female;
  }
  else {
    fmtout(f, 9, 3, totdistance);
    fmtout(f, 9, 3, nb > 0 ? totxover/nb*100.0 : 0);
    fmtout(f, 9, 2, totxover);
    f << setw(7) << nb;
  }
  f << "  " << markername(map->num - 1) << "\n";
}

void Recombmodel::totline(ostream &f, Uint pos) {
  Double xoversum = ((Recombdist *)distribution)->xoversum(pos);
  totxover += xoversum;
  if (options->sexspecific) {
    Double xoversum_female =
      ((Recombdist *)distribution)->xoversum_female(pos);
    totxover_female += xoversum_female;
    totdistance += centimorgan(map->theta[1][pos]);
    totdistance_female += centimorgan(map->theta[2][pos]);
    fmtout(f, 9, 3, centimorgan(map->theta[1][pos]));
    fmtout(f, 6 + options->xoverrateprecision, options->xoverrateprecision,
           (bitsum_male > 0 ? xoversum/bitsum_male*100.0 : 0));
    f << setw(7) << bitsum_male;
    fmtout(f, 9, 3, centimorgan(map->theta[2][pos]));
    fmtout(f, 6 + options->xoverrateprecision, options->xoverrateprecision,
           (bitsum_female > 0 ? xoversum_female/bitsum_female*100.0 : 0));
    f << setw(7) << bitsum_female << "  ";
  }
  else {
    totdistance += centimorgan(map->theta[0][pos]);
    fmtout(f, 9, 3, centimorgan(map->theta[0][pos]));
    fmtout(f, 6 + options->xoverrateprecision, options->xoverrateprecision,
           xoversum/bitsum*100.0);
    fmtout(f, 9, 2, xoversum);
    f << setw(7) << bitsum << "  ";
  }
}

void Recombmodel::famline(ostream &f, Uint ifa, Uint pos) {
  Double xover = ((Recombdist *)distribution)->xover(ifa, pos);
  totxover += xover;
  if (options->sexspecific) {
    Double xover_female = ((Recombdist *)distribution)->xover_female(ifa, pos);
    totxover_female += xover_female;
    totdistance += centimorgan(map->theta[1][pos]);
    totdistance_female += centimorgan(map->theta[2][pos]);
    fmtout(f, 9, 3, centimorgan(map->theta[1][pos]));
    Uint nbits = ((Recombdist *)distribution)->nbits_male(ifa);
    fmtout(f, 6 + options->xoverrateprecision, options->xoverrateprecision,
           (nbits > 0 ? xover/nbits*100.0 : 0));
    f << setw(7) << nbits;
    fmtout(f, 9, 3, centimorgan(map->theta[2][pos]));
    Uint nbits_female = ((Recombdist *)distribution)->nbits_female(ifa);
    fmtout(f, 6 + options->xoverrateprecision, options->xoverrateprecision,
           (nbits_female > 0 ? xover_female/nbits_female*100.0 : 0));
    f << setw(7) << nbits_female << "  ";
  } else {
    totdistance += centimorgan(map->theta[0][pos]);
    f.setf(ios::right, ios::adjustfield);
    fmtout(f, 9, 3, centimorgan(map->theta[0][pos]));
    Uint nbits = ((Recombdist *)distribution)->nbits(ifa);
    fmtout(f, 6 + options->xoverrateprecision, options->xoverrateprecision,
           (nbits > 0 ? xover/nbits*100.0 : 0));
    fmtout(f, 9, 2, xover);
    f << setw(7) << nbits << "  ";
  }
}

void Recombmodel::totheader(ostream &f) {
  if (options->sexspecific)
    f << "   mdist mxoverrate mnmei   fdist fxoverrate fnmei ";
  else
    f << " distance xoverrate  nxover   nmei ";
}

void Recombmodel::famheader(ostream &f) {
  if (options->sexspecific)
    f << "   mdist mxoverrate mnmei   fdist fxoverrate fnmei ";
  else
    f << " distance xoverrate nxover  nmei ";
}

void Recombmodel::print() const {
  message("CROSSOVERRATE " + outfile.name + " " + foutfile.name);
}

void Recombmodel::output() {
  ((Recombdist *)distribution)->calcxovers();
  Output::output();
}
