#include "files.h"
#include "scoredist.h"
#include "scoredistfull.h"
#include "scoredistmoments.h"
#include "calcscore.h"
#include "family.h"

Scoredist *Scoredist::getscoredist(const string &pt, Calcscore *cs, Uint deg) {
  for (Uint d = 0; d < distributions.size(); d++)
    if (cs->describe() == distributions[d]->describe() &&
        pt == distributions[d]->getpt()) {
      Scoredist *sdist = (Scoredist *)distributions[d];
      if (deg == 0 && sdist->getdegree() == 0 ||
          deg != 0 && sdist->getdegree() >= deg)
        return sdist;
      else if (deg != 0 && sdist->getdegree() != 0) {
        sdist->degree = deg;
        return sdist;
      }
    }
  Scoredist *sd = 0;
  if (deg == 0) {
    sd = new Scoredistfull(pt, (cs->isdiscrete() ? 10000.0 : -9.99e50));
  }
  else sd = new Scoredistmoments(pt, deg);
  sd->calcscore = cs;
  return sd;
}

string Scoredist::describe() const {
  return calcscore->describe();
}

bool Scoredist::usefamily(Family *fam) const {
  Uint naff = 0;
  for (Person *p = fam->first; p != 0; p = p->next) 
    if (p->dstat == AFFECTED) naff++;
  return naff > 1 && fam->numbits > 0;
}
