#ifndef _SCOREDIST
#define _SCOREDIST
#include "basic.h"
#include "distribution.h"

class Calcscore;

class Scoredist : public Distribution {
public:
  virtual ~Scoredist() {}

  static Scoredist *getscoredist(const string &pt, Calcscore *cs, Uint deg = 0);
  Uint getdegree() const {return degree;}
  virtual string describe() const;

  // Family if used if it is more than 0 bits and has more than 1 affected
  virtual bool usefamily(Family *fam) const;
  /// Returns true if families that have no uninformative markers are to be
  /// used
  virtual bool useuninformative() const {return false;}
protected:
  Scoredist(const string &p, Uint deg = 0):
      Distribution(p), degree(deg), calcscore(0) {}
  
  Uint degree; // Number of moments stored (0 = full distribution stored)
  Calcscore *calcscore;
};

#endif // _SCOREDIST
