#include "files.h"
#include "scoredistfull.h"
#include "family.h"
#include "map.h"
#include "fmtout.h"
#include "calcscore.h"

Scoredistfull::Scoredistfull(const string &p, Float maxs) :
    Scoredist(p, 0), maxscore(maxs), scoreval(0), iscoreval(0), lowtable(0) {
  curmaxscore = Uint(maxscore) - 1;
  if (maxscore > 0) NEWVEC(Double, lowtable, Uint(maxscore));
}

Scoredistfull::~Scoredistfull() {
  while (!familydata.empty()) {
    delete familydata.back();
    familydata.pop_back();
  }
  DELETEVEC(lowtable);
}

void Scoredistfull::reset(Uint np) {
  while (!familydata.empty()) {
    delete familydata.back();
    familydata.pop_back();
  }
  npos = np;
}

void Scoredistfull::zerotables() {
  if (maxscore > 0) zero(lowtable, curmaxscore + 1);
  for (Table::iterator i = hightable.begin(); i != hightable.end(); i++)
    i->second = 0.0;
}

void Scoredistfull::nextfam(Uint pos, FloatVec p0) {
  if (pos == 0) {
    DELETEVEC(iscoreval);
    familydata.push_back(new Familydata(this));
  }
  Familydata *famdat = familydata.back();
  Uint numscores = (curfamily()->numiv*
                    POW2[curfamily()->nasymmetricfoundercouples()]);
  if (pos == 0) {
    scoreval = calcscore->vec;
    NEWVEC(Uint, iscoreval, numscores);
    for (IV v = 0; v < numscores; v++) iscoreval[v] = Uint(scoreval[v]);
    hightable.clear();
    zerotables();
    curmaxscore = 0;
    for (IV v = 0; v < numscores; v++) {
      if (scoreval[v] >= maxscore) {
        if (hightable.find(scoreval[v]) == hightable.end())
          hightable.insert(Table::value_type(scoreval[v], 0.0));
      }
      else if (maxscore > 0) {
        lowtable[iscoreval[v]] = 1.0;
        if (curmaxscore < iscoreval[v]) curmaxscore = iscoreval[v];
      }
    }
    Uint scidx = hightable.size();
    if (maxscore > 0)
      for (Uint i = 0; i <= curmaxscore; i++)
        if (lowtable[i] != 0.0) scidx++;
    famdat->nscores = scidx;
    assertcond(famdat->nscores > 0, "No score possible!");
    NEWMAT(Double, famdat->nullprob, npos, famdat->nscores);
    zero(famdat->nullprob[0], npos*famdat->nscores);
    NEWVEC(Double, famdat->value, famdat->nscores);
    scidx = 0;
    for (IT i = hightable.begin(); i != hightable.end(); i++) {
      famdat->value[scidx] = i->first;
      scidx++;
    }
    if (maxscore > 0)
      for (Uint i = 0; i <= curmaxscore; i++) {
        if (lowtable[i] != 0.0) {
          famdat->value[scidx] = i;
          scidx++;
        }
      }
  }
  zerotables();
  if (isnullconstant()) {
    Double unif = 1.0/Double(numscores);
    for (IV v = 0; v < numscores; v++) {
      if (scoreval[v] < maxscore) lowtable[iscoreval[v]] += unif;
      else hightable[scoreval[v]] += unif;
    }
  }
  else updatetables(p0);
  tablestoprob(famdat->nullprob[pos]);
}

void Scoredistfull::tablestoprob(DoubleVec d) {
  Uint scidx = 0;
  Familydata *famdat = familydata.back();
  for (IT i = hightable.begin(); i != hightable.end(); i++) {
    assertinternal(i->first >= famdat->value[scidx]);
    while (i->first > famdat->value[scidx]) scidx++;
    d[scidx] = i->second;
    scidx++;
  }
  if (maxscore > 0) 
    for (Uint i = 0; i <= curmaxscore; i++) {
      if (lowtable[i] != 0.0) {
        if (Double(i) >= famdat->value[scidx])
          assertinternal(Double(i) >= famdat->value[scidx]);
        while (Double(i) > famdat->value[scidx]) scidx++;
        d[scidx] = lowtable[i];
        scidx++;
      }
    }
}

void Scoredistfull::updatetables(FloatVec pv) {
  for (Uint a = 0; a < POW2[curfamily()->nasymmetricfoundercouples()]; a++) {
    UintVec is = iscoreval + a*curfamily()->numiv;
    DoubleVec sv = scoreval + a*curfamily()->numiv;
    for (IV v = 0; v < curfamily()->numiv; v++) {
      if (sv[v] < maxscore) lowtable[is[v]] += pv[v];
      else hightable[sv[v]] += pv[v];
    }
  }
}

void Scoredistfull::set(FloatVec pv, Uint pos) {
  zerotables();
  updatetables(pv);
  Familydata *famdat = familydata.back();
  NEWVEC(Double, famdat->prob[pos], famdat->nscores);
  zero(famdat->prob[pos], famdat->nscores);
  tablestoprob(famdat->prob[pos]);
  if (curfamily()->nasymmetricfoundercouples() > 0) {
    Double fac = 1.0/POW2[curfamily()->nasymmetricfoundercouples()];
    for (Uint i = 0; i < famdat->nscores; i++)
      famdat->prob[pos][i] *= fac;
  }
}

void Scoredistfull::skipfam() {
  if (!familydata.empty()) {
    delete familydata.back();
    familydata.pop_back();
  }
}

Float position_tmp(Uint pos, const string &pt, const Map &map) {
  if (pt == "mpt") return map.position[0][pos];
  else return map.markerpos[0][pos];
}

void Scoredistfull::writeprob(const Map &map) {
  if (!probfileout.is_open()) probfileout.open();
  Familydata *famdat = familydata.back();
  for (Uint pos = 0; pos < npos; pos++) {
    if (map.inbetween[pos] || map.shouldfindp[map.leftmarker[pos]]) {
      for (Uint i = 0; i < famdat->nscores; i++) {
        probfileout << curfamily()->id << '\t';
        fmtout(probfileout, 5, 4, position_tmp(pos, pt, map));
        probfileout.setf(ios::scientific | ios::showpoint, ios::floatfield);
        probfileout.precision(10);
        probfileout << '\t' << famdat->value[i] << '\t'
                    << famdat->prob[pos][i] << "\n";
      }
    }
  }
}

void Scoredistfull::readprob(Infile& /*f*/) {
//    const int NV = 10000;
//    f.open();
//    string famid, fid;
//    ifam = 0;
//    Uint ipos = 0;
//    Uint n = 0;
//    Uint nval = NV;
//    DoubleVec val = New<Double>(NV, "Scoredistfull.val");
//    DoubleVec prb = New<Double>(NV, "Scoredist.prb");
//    Double pos;
//    f >> famid >> ws;
//    f >> pos >> ws;
//    assertcond(!f.eof() && f.good(), "Illegal format of probfile " + f.name);
//    while (!f.eof()) {
//      if (n >= nval) {
//        assertinternal(n == nval);
//        enlarge(val, nval, NV);
//        enlarge(prb, nval, NV);
//        nval += NV;
//      }
//      f >> val[n] >> prb[n] >> ws;
//      f >> fid >> ws;
//      f >> pos >> ws;
//      n++;
//      assertcond(f.eof() || f.good(), "Illegal format of probfile " + f.name);
//      assertcond(ipos < npos, "Illegal format of probfile " + f.name
//                 + ", too many loci, family " + famid);
//      if (f.eof() || famid != fid || fabs(pos - position[ipos]) >= 1e-4) {
//        if (value[ifam] == 0) {
//          value[ifam] = New<Double>(n, "Scoredist.value[ifam]");
//          copyvec(value[ifam], val, n);
//          nscores[ifam] = n;
//        }
//        else
//          assertcond(nscores[ifam] == n,"Wrong format of prob file " + f.name);
//        assertcond(prob[ifam][ipos] == 0, "Two prob files read ...");
//        prob[ifam][ipos] = New<Double>(n, "Scoredist.value[ifam]");
//        copyvec(prob[ifam][ipos], prb, n);
//        ipos++;
//        if (f.eof() || famid != fid) {
//          assertcond(ifam < nfam, "Too many families in probfile " + f.name);
//          famid = fid;
//          ipos = 0;
//          ifam++;
//        }
//        else
//          assertcond(fabs(pos - position[ipos]) < 1e-4, "Illegal format of " +
//                     f.name + ", family " + famid + ", wrong locus " + pos);
//        n = 0;
//      }
//    }
//  //  assertcond(ifam == nfam, "Too few families in probfile " + f.name);
//    ifam--;
//    f.close();
//    Delete(val, NV, "Scoredist.val");
//    Delete(prb, NV, "Scoredist.prb");
}

void Scoredistfull::writenull() {
  if (!nullfileout.is_open()) nullfileout.open();
  Familydata *famdat = familydata.back();
  nullfileout.setf(ios::scientific | ios::showpoint, ios::floatfield);
  nullfileout.precision(10);
  for (Uint i = 0; i < famdat->nscores; i++)
    nullfileout << curfamily()->id << '\t'
                << Uint(famdat->nullprob[0][i]*curfamily()->numiv)
                << '\t' << famdat->value[i] << "\n";
}

void Scoredistfull::readnull(Infile& /*f*/) {
//    const int NV = 10000;
//    f.open();
//    string famid, fid;
//    Uint ifa = 0;
//    Uint n = 0;
//    Uint nval = NV;
//    DoubleVec val = New<Double>(NV, "Scoredist.val");
//    DoubleVec prb = New<Double>(NV, "Scoredist.prb");
//    f >> famid >> ws;
//    assertcond(!f.eof() && f.good(), "Illegal format of nullprob file " + f.name);
//    while (!f.eof()) {
//      if (n >= nval) {
//        assertinternal(n == nval);
//        enlarge(val, nval, NV);
//        enlarge(prb, nval, NV);
//        nval += NV;
//      }
//      f >> prb[n] >> val[n] >> ws;
//      f >> fid >> ws;
//      n++;
//      assertcond(f.eof() || f.good(), "Illegal format of nullprob file " + f.name);
//      if (f.eof() || famid != fid) { // Next family
//        assertcond(ifa < nfam, "Too many families in nullprob file " + f.name);
//        if (value[ifa] == 0) {
//          value[ifa] = New<Double>(n, "Scoredist.value[ifa]");
//          copyvec(value[ifa], val, n);
//          nscores[ifa] = n;
//        }
//        else {
//          assertcond(nscores[ifa] == n,"Nullprob file " + f.name
//                     + " is incompatible with prob file");
//        }
//        assertcond(nullprob[ifa] == 0, "Two nullprob files read ...");
//        nullprob[ifa] = New<Double>(n, "Scoredist.nullprob[ifa]");
//        copyvec(nullprob[ifa], prb, n);
//        normal(nullprob[ifa], n);
//        famid = fid;
//        ifa++;
//        n = 0;
//      }
//    }
//    f.close();
//    Delete(val, NV, "Scoredist.val");
//    Delete(prb, NV, "Scoredist.prb");
}

void Scoredistfull::getresults(UintVec nscores, DoubleMat value,
                               DoubleMat *prob, DoubleMat *nullprob) {
  for (Uint fam = 0; fam < familydata.size(); fam++) {
    nscores[fam] = familydata[fam]->nscores;
    value[fam] = familydata[fam]->value;
    prob[fam] = familydata[fam]->prob;
    for (Uint pos = 0; pos < nnulldist(); pos++)
      nullprob[pos][fam] = familydata[fam]->nullprob[pos];
  }
}
