#ifndef _SCOREDISTFULL
#define _SCOREDISTFULL
#include "scoredist.h"
#include "vecutil.h"

typedef map<Double, Double> Table;

class Scoredistfull : public Scoredist {
  friend class Scoredist;
public:
  virtual ~Scoredistfull();
  
  // Function for extracting results
  void getresults(UintVec nscores, DoubleMat value, DoubleMat *prob,
                  DoubleMat *nullprob);
protected:
  Scoredistfull(const string &pt, Float maxs = 10000.0);

  class Familydata {
  protected:
    Scoredistfull *owner;
  public:
    Familydata(Scoredistfull *own) : owner(own), value(0), nullprob(0) {
      NEWVEC(DoubleVec, prob, owner->npos);
      zero(prob, owner->npos);
    }
    Familydata(const Familydata &fd) : owner(fd.owner) {
      NEWVEC(DoubleVec , prob, owner->npos);
      zero(prob, owner->npos);
    }
    ~Familydata() {
      for (Uint i = 0; i < owner->npos; i++)
        DELETEVEC(prob[i]);
      DELETEVEC(prob);
      DELETEVEC(value);
      DELETEVEC(nullprob);
    }
    
    DoubleVec value;
    DoubleMat prob;
    DoubleMat nullprob;
    Uint nscores;
  };
  friend class Scoredistfull::Familydata;
  typedef vector<Familydata *> Familydatavector;
  Familydatavector familydata;
  
  Float maxscore;
  typedef Table::const_iterator IT;
  Uint curmaxscore;
  DoubleVec scoreval;
  UintVec iscoreval;
  Table hightable;
  DoubleVec lowtable;

  void zerotables();
  void updatetables(FloatVec pv);
  void tablestoprob(DoubleVec d);
  virtual void reset(Uint np);
  virtual void nextfam(Uint pos = 0, FloatVec p0 = 0);
  virtual void set(FloatVec pv, Uint pos);
  virtual void skipfam();

  virtual void writeprob(const Map &map);
  virtual void readprob(Infile& f);
  virtual void writenull();
  virtual void readnull(Infile& f);
};

#endif // _SCOREDISTFULL
