#ifndef _SCOREDISTMOMENTS
#define _SCOREDISTMOMENTS
#include "scoredist.h"
#include "vecutil.h"
#include "utils.h"

class Scoredistmoments : public Scoredist {
  friend class Scoredist;
public:
  virtual ~Scoredistmoments();
  
  // Function for extracting results
  void getresults(DoubleMat *value, DoubleMat *nullvalue,
                  DoubleMat nullmean, DoubleMat nullsd, Uint deg,
                  DoubleVec minvalue, DoubleVec maxvalue);

protected:
  Scoredistmoments(const string &p, Uint deg);

  class Familydata {
  protected:
    Scoredistmoments *owner;
  public:
    Familydata(Scoredistmoments *own) : owner(own), value(0), nullvalue(0),
      minvalue(0.0), maxvalue(0.0) {
      NEWVEC(Double, nullmean, owner->npos);
      zero(nullmean, owner->npos);
      NEWVEC(Double, nullsd, owner->npos);
      zero(nullsd, owner->npos);
      NEWMAT(Double, value, owner->npos, owner->degree);
      zero(value[0], owner->npos*owner->degree);
      NEWMAT(Double, nullvalue, owner->nnulldist(), max_(2, owner->degree));
      zero(nullvalue[0], max_(2, owner->degree)*owner->nnulldist());
    }
    Familydata(const Familydata &fd) : owner(fd.owner) {
      NEWVEC(Double, nullmean, owner->npos);
      zero(nullmean, owner->npos);
      NEWVEC(Double, nullsd, owner->npos);
      zero(nullsd, owner->npos);
      NEWMAT(Double, value, owner->npos, owner->degree);
      zero(value[0], owner->npos*owner->degree);
      NEWMAT(Double, nullvalue, owner->nnulldist(), max_(2, owner->degree));
      zero(nullvalue[0], max_(2, owner->degree)*owner->nnulldist());
      minvalue = fd.minvalue;
      maxvalue = fd.maxvalue;
    }
    ~Familydata() {
      DELETEVEC(nullmean);
      DELETEVEC(nullsd);
      DELETEMAT(value);
      DELETEMAT(nullvalue);
    }
    DoubleVec nullmean;
    DoubleVec nullsd;
    
    DoubleMat value;
    DoubleMat nullvalue;

    Double minvalue;
    Double maxvalue;
  };
  friend class Scoredistmoments::Familydata;
  typedef vector<Familydata *> Familydatavector;
  Familydatavector familydata;

  virtual void reset(Uint np);
  virtual void nextfam(Uint pos = 0, DoubleVec p0 = 0);
  virtual void set(FloatVec pv, Uint pos);
  virtual void skipfam();

  virtual void writeprob(const Map &/*map*/) {}
  virtual void readprob(Infile& /*f*/) {}
  virtual void writenull() {}
  virtual void readnull(Infile& /*f*/) {}
};

#endif // _SCOREDISTMOMENTS
