#ifndef _SIMULATION
#define _SIMULATION
#include "basic.h"

class Trait;

class Simulation { 
public:
  Simulation() :
      diseasepos(-1), nsimulations(1), nrepeats(1), errorrate(0.0), yield(1.0),
      hetrogen(0.0), perfectdata(false), trait(0), nu_male(1.0), nu_female(1.0),
      fam(0), L(0), firstfam(true) {}
  void simulate(Family *famp, const Map &map);
  void setbuf(DoubleVec Lp) {L = Lp;}

  Float diseasepos;
  int nsimulations;
  int nrepeats;
  Float errorrate;
  Float yield;
  Float hetrogen;
  bool perfectdata;
  Trait *trait;
  Double nu_male;
  Double nu_female;
private:
  static const int LEFT = -1;
  static const int RIGHT = 1;
  void setfoundergenotypes(const Map &map);
  void simulatefromdiseaselocus(const Map &map, IV v);
  static void initicd(Double dist, Double nu,
                      Float &left_icd, Float &right_icd);
  void inittrans(IV v);
  void simulateicd(const Map &map, Uint from, FloatVec paticd,
                   FloatVec maticd, int dir);
  void simulatemarker(const Map &map, int gam);
  Family *fam;          // associated family
  DoubleVec L;          // Probability distribuiton at disease locus
  bool firstfam;
  int pattrans[100];
  int mattrans[100];
};

#endif // _SIMULATION
