#ifndef _SINGLELOCUS
#define _SINGLELOCUS
#include <iostream>
#include "basic.h"

class Node;

class Edge {
//protected:
public:
  Allele a0;
  Allele a1;
  Node *n0; // Node and Edge pointers are only used in haplotyping part
  Node *n1;
  Edge *next;
  Float prob;

  Edge(Allele b0, Allele b1, FloatVec freq) :
      a0(b0), a1(b1), prob(sqrt(2.0*freq[a0 - 1]*freq[a1 - 1])) {}
  Edge(Allele b0, Allele b1, Node *m0, Node *m1) :
      a0(b0), a1(b1), n0(m0), n1(m1), next(0), prob(1.0) {}
  friend class Node;
};

class Node {
public:
  Node *next;
  bool genotyped;
  Allele allele;
  Edge *edge;
  Uint index;

  void getBlock(vector<unsigned int> &b1, vector<unsigned int> &b2);
protected:
  Node *neighbour; // Neighbour in single locus peel

  Node(Node *n = 0) : next(n), genotyped(false), allele(ALLELEUNKNOWN),
    edge(0), neighbour(0) {}
  inline bool setallele(Allele a) {
    if (neighbour) {
      if (edge->a0 == a) neighbour->allele = edge->a1;
      else if (edge->a1 == a) neighbour->allele = edge->a0;
      else return false;
    }
    allele = a;
    return true;
  }
  inline void unsetallele() {
    allele = ALLELEUNKNOWN;
    if (neighbour) neighbour->allele = ALLELEUNKNOWN;
  }

  bool haplosetallele(Allele a);
  void clearallele();
  friend class Graph;
};

class Graph {
public:
  FloatVec allelefreq;
  Node *first;
  Graph(Person *frst);
  ~Graph();

  void setallelefreq(FloatVec af) {allelefreq = af;}
 
  inline Double probability() const {
    Double prob = 1.0;
    for (Node *cur = first; cur != 0; cur = cur->next) {
      if (!cur->genotyped && cur->allele != ALLELEUNKNOWN)
        prob *= allelefreq[cur->allele - 1];
      else if (cur->edge != 0)
        prob *= cur->edge->prob;
    }
    return prob;
  }
  
  Node *addnode(); // adds one node
  void addfounderedge(Node *n0, Node *n1, Allele b0, Allele b1) const;
  inline void addedge(Node *n0, Node *n1, Edge *e) const {
    // Only call this function if the alleles of n0 and n1 have not been set
    n1->edge = n0->edge = e;
    n0->neighbour = n1;
    n1->neighbour = n0;
  }
  
  inline bool addgenotype(Node *n0, Node *n1, Allele b0, Allele b1,
                          bool &n0set, bool &n1set) const {
    n0set = n1set = false;
    if (n0->allele != b0) {
      if (n0->allele == ALLELEUNKNOWN && n0->setallele(b0)) n0set = true;
      else return false;
    }
    if (n1->allele != b1) {
      if (n1->allele == ALLELEUNKNOWN && n1->setallele(b1)) n1set = true;
      else {
        if (n0set) {
          n0->unsetallele();
          n0set = false;
        }
        return false;
      } 
    }
    return true;
  }
  
  inline void removegenotype(Node *n0, Node *n1, bool n0set, bool n1set) const {
    if (n0set) n0->unsetallele();
    if (n1set) n1->unsetallele();
  }
  inline void removeedge(Node *n0, Node *n1) const {
    n1->edge = n0->edge = 0;
    n0->neighbour = n1->neighbour = 0;
  }
  void reset();

  // Haplotyping methods:
  bool addgenotype(Node *n0, Node *n1, Allele a0, Allele a1);
  void assignalleles(bool pickmle);
  void haploreset();

  friend class Node;
};

#endif //SINGLELOCUS
