#include <sys/times.h>
#include <limits.h>
#ifndef _TIMER
#define _TIMER

#ifdef DEBUG
#define TIMER(tim) timer tim
#define TIME(tim,s) cout << s << " time " << tim.elapsed() << endl; tim.reset()
#else
#define TIMER(tim)
#define TIME(tim,s)
#endif

#ifdef DEBUG
class timer {
  tms start;
  double timesofar;
  bool paused;
public:
  timer() {reset();}
  void reset() { timesofar = 0.0; restart(); }
  void restart() { paused = false; times(&start); }
  void pause() { timesofar = elapsed(); paused = true; }
  double elapsed() {
    if (paused) return timesofar;
    else {
      tms tmpbuf;
      times(&tmpbuf);
      return timesofar + double(((tmpbuf.tms_utime/* + tmpbuf.tms_stime*/) -
                                 (start.tms_utime/* + start.tms_stime*/))
                                * CLK_TCK) / 1e4;
    }
  }
};
#endif

#endif // _TIMER
