#ifndef _TRAIT
#define _TRAIT
#include "basic.h"
#include "fmtout.h"

class Trait {
public:
  Float disfreq;         // disease gene frequency (prevalence)
  Uint nliability;
  FloatMat penetrance;

protected:
  bool sexlinked;
  void init() {NEWMAT(Float, penetrance, nliability, 3);}

public:
  Trait() : disfreq(0.0), nliability(1), sexlinked(false) {init();}
  Trait(Float df, Float p0, Float p1, Float p2, bool sxlnkd) :
      disfreq(df), nliability(1), sexlinked(sxlnkd)
    {init(); penetrance[0][0] = p0; penetrance[0][1] = p1; penetrance[0][2] = p2;}
  Trait(Uint nliab, Float df, bool sxlnkd) :
      disfreq(df), nliability(nliab), sexlinked(sxlnkd) {init();}
  ~Trait() {DELETEMAT(penetrance);}
//  string getpenetrances() const {
//    string penetrances = Floattostring(penetrance[0][0], 4) + "/" +
//      Floattostring(penetrance[0][1], 4) + "/" +
//      Floattostring(penetrance[0][2], 4);
//    if (sexlinked)
//      penetrances += "/" + Floattostring(penetrance[1][0], 4) +
//        "/" + Floattostring(penetrance[1][1], 4);
//    return penetrances;
//  }
//  string getfreq() const {return Floattostring(disfreq, 4);}
  bool getsexlinked() const {return sexlinked;}

  string describe() const {
    string desc = "";
    if (sexlinked)
      desc += "X ";
    desc += "freq:" + Floattostring(disfreq, 4) + " pen:" +
      Floattostring(penetrance[0][0], 4) + "/" +
      Floattostring(penetrance[0][1], 4) + "/" +
      Floattostring(penetrance[0][2], 4);
    if (sexlinked)
      desc += "/" + Floattostring(penetrance[1][0], 4) +
        "/" + Floattostring(penetrance[1][1], 4);
    return desc;
  }
};

inline bool operator==(const Trait &a, const Trait &b) {
  bool equal = a.nliability == b.nliability && a.disfreq == b.disfreq;
  if (equal) 
    for (Uint i = 0; i < a.nliability && equal; i++) 
      equal &= a.penetrance[i][0] == b.penetrance[i][0] &&
        a.penetrance[i][1] == b.penetrance[i][1] &&
        a.penetrance[i][2] == b.penetrance[i][2];
  return equal;
}

#endif // _TRAIT
