#include "files.h"
#include "calcqtl.h"
#include "varcompmodel.h"
#include "inherdist.h"

Varcompmodel::Varcompmodel(const string &p, bool maxG, bool maxA, bool maxD,
                           Double shr, bool pih,
                           const string &of, const string &fof) :
    QTLmodel(p, false, maxG, maxA, maxD, 1.0, shr), pihat(pih) {
  setfiles(of, fof, string("varcomp.") + shr + "." + pih + "." + pt,
           "variance component file");
  if (pihat) distribution = IBDdist::getibddist(pt, "qtl");
  else distribution = Inherdist::getinherdist(pt);
}

Double Varcompmodel::calculate(DoubleVec fl, Double S, Double G,
                               Double A, Double D, Uint gam) {
  if (pihat) {
    IBDdist *pairwiseibd = (IBDdist *)distribution;
    Double l = 0.0;
    for (Uint ifam = 0; ifam < nfam(); ifam++) {
      Family *fam = distribution->families[ifam];
      fam->calckinship();
      FloatVec ibd1;
      FloatVec ibd2;
      pairwiseibd->getposterioribd(ifam, ibd1, ibd2, gam);
      l += fl[ifam] = loglik.calc(fam, ibd1, ibd2, S, G, A, D)/log(10.);
    }
    return l;
  }
  else
    return QTLmodel::calculate(fl, S, G, A, D, gam);
}

void Varcompmodel::print() const {
  string msg = "MODEL " + pt + " varcomp shared:";
  if (shared < 0) msg += "max";
  else msg = msg + shared;
  message(msg + " " + (pihat ? "pihat" : "admix") + " " + outfile.name + " " +
          foutfile.name);
}
