#ifndef _VITERBIDIST
#define _VITERBIDIST
#include "basic.h"
#include "distribution.h"

class Calcviterbi;
class Graph;
class Foundercouple;

class Viterbidist : public Distribution {
public:
  virtual ~Viterbidist();

protected:
  Viterbidist(const string &p);
  IVVec path;
private:
  Calcviterbi *calc;
  IV ntmpfc;
  IV ntmp;
  FloatVec tmpfloat;
  FloatVec tmpfcfloat;
  IVVec tmpiv;
  IVVec tmpfciv;

  void step(FloatVec p0, IVVec h, Float tht, Float tht_female);

  inline void dobits(FloatVec p, IVVec h, Float fac, IV frombit, IV tobit,
                     IV N);
  inline void dofounder(FloatVec p0, IVVec h, Float fac, IV N, IV mask,
                        IV lastbit);
  inline void dofcfounders(FloatVec p0, IVVec h, Float fac, Uint wm, IV wb,
                           IV hm, IV hb, IV start, IV inc, IV end);
  inline void dofc(FloatVec p0, IVVec h, Float fac, IV frombit, IV tobit,
                   IV start, IV inc, IV end);
  inline void dofounderloop(FloatVec p0, IVVec h, Float fac, IV base, IV mask,
                            IV lastbit);
  inline void dobit(Float &a, Float &b, IV &ha, IV &hb, Float fac) {
    Float t1 = a;
    Float t2 = b*fac;
    IV ht = ha;
    if (a < t2) {
      a = t2;
      ha = hb;
    }
    t2 = t1*fac;
    if (b < t2) {
      b = t2;
      hb = ht;
    }
  }
  inline void doinversebit(Float &a, Float &b, IV &ha, IV &hb, Float fac) {
    Float t1 = a;
    Float t2 = a*fac;
    IV ht = ha;
    if (t2 < b) {
      a = b;
      ha = hb;
    }
    else a = t2;
    t2 = b*fac;
    if (t2 < t1) {
      b = t1;
      hb = ht;
    }
    else b = t2;
  }

  void calculatefcpi(IV base, FloatVec p0, IVVec h, Foundercouple *fc);
protected:
  Uint countfounderrecombs(IV mask, IV v0, IV v1,
                           Uint &same, Uint &diff) const ;
  Uint countfcrecombs(Foundercouple *fc, IV v0, IV v1,
                      Uint &same, Uint &diff) const;
  Uint countrecombs(Family *f, IV v0, IV v1) const;

  virtual void gettheta(Uint gam, Float &tht, Float &tht_female) const;
  
  virtual void reset(Uint np);
  virtual void nextfam(Uint pos = 0, DoubleVec p0 = 0);
  virtual void set(FloatVec pv, Uint pos);
  virtual void skipfam() {}

  virtual void writeprob(const Map &/*mp*/) {}
  virtual void readprob(Infile& /*f*/) {}
  virtual void writenull() {}
  virtual void readnull(Infile& /*f*/) {}
};

#endif // _VITERBIDIST
