#include "warning.h"
#include <time.h>
#include <stdio.h>
#include <iostream>

ofstream *logfile;

static int optionslinenumber;

void setoptlinenum(int n) {
  optionslinenumber = n;
}

string operator +(const string& s, int n) {
  char ns[50];
  sprintf(ns, "%d", n);
  return s + ns;
}

string operator +(const string& s, Uint n) {
  char ns[50];
  sprintf(ns, "%ld", n);
  return s + ns;
}

string operator +(const string& s, Double a) {
  char ns[50];
  sprintf(ns, "%g", a);
  return s + ns;
}

char buf[30];

// write warning to the logfile and to cerr:
void message(const string &msg) {
  time_t t;
  time(&t);
  strftime(buf, 30, "<%a-%G-%b-%d-%X> ", gmtime(&t));
  if (logfile != 0) *logfile << buf << msg << endl;
  cerr << msg << endl;
}

void warning(const string &msg) {
  message("WARNING " + msg);
}

void optwarning(const string& msg) {
  warning(msg + " on line " + optionslinenumber + " in options file");
}

void optassert(bool cond, const string &msg) {
  assertcond(cond, msg + " on line " + optionslinenumber + " in options file");
}

void fatal(const string& s) {
  assertcond(false, s);
}
